/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.spring;

import java.util.Optional;
import org.iherus.shiro.cache.redis.config.RedisConfiguration;
import org.iherus.shiro.cache.redis.connection.BatchOptions;
import org.iherus.shiro.cache.redis.connection.RedisConnection;
import org.iherus.shiro.cache.redis.connection.RedisConnectionFactory;
import org.iherus.shiro.cache.redis.connection.spring.CompatibleRedisConnection;
import org.iherus.shiro.util.Utils;

public class CompatibleRedisConnectionFactory
implements RedisConnectionFactory {
    private org.springframework.data.redis.connection.RedisConnectionFactory nativeConnectionFactory;
    private Optional<BatchOptions> batchOptions = Optional.empty();

    public CompatibleRedisConnectionFactory() {
    }

    public CompatibleRedisConnectionFactory(org.springframework.data.redis.connection.RedisConnectionFactory connectionFactory) {
        Utils.assertNotNull(connectionFactory, "Spring's RedisConnectionFactory must not be null.");
        this.nativeConnectionFactory = connectionFactory;
    }

    public Optional<BatchOptions> getBatchOptions() {
        return this.batchOptions;
    }

    @Override
    public void setBatchOptions(BatchOptions batchOptions) {
        this.batchOptions = Optional.ofNullable(batchOptions);
    }

    public org.springframework.data.redis.connection.RedisConnectionFactory getNativeConnectionFactory() {
        return this.nativeConnectionFactory;
    }

    public void setNativeConnectionFactory(org.springframework.data.redis.connection.RedisConnectionFactory connectionFactory) {
        this.nativeConnectionFactory = connectionFactory;
    }

    @Override
    public RedisConnection getConnection() {
        return new CompatibleRedisConnection(this.nativeConnectionFactory.getConnection(), this.batchOptions.orElse(BatchOptions.defaulted));
    }

    @Override
    public RedisConfiguration getConfiguration() {
        throw new UnsupportedOperationException("This operation is not supported.");
    }
}

