/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.serializer;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.shiro.io.SerializationException;
import org.apache.shiro.io.Serializer;
import org.iherus.shiro.util.Utils;

public class StringSerializer
implements Serializer<String> {
    public static final StringSerializer UTF_8 = new StringSerializer();
    private final Charset charset;

    public StringSerializer() {
        this(StandardCharsets.UTF_8);
    }

    public StringSerializer(Charset charset) {
        Utils.assertNotNull(charset, "Charset must not be null!");
        this.charset = charset;
    }

    public byte[] serialize(String string) throws SerializationException {
        return string == null ? null : string.getBytes(this.charset);
    }

    public String deserialize(byte[] bytes) throws SerializationException {
        return bytes == null ? null : new String(bytes, this.charset);
    }
}

