/**
 * Copyright (c) 2016-2019, Bosco.Liao (bosco_liao@126.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.iherus.shiro.cache.redis.connection;

import java.time.Duration;
import java.util.List;
import java.util.Set;

public interface RedisCacheCommands {

	byte[] get(byte[] key);

	byte[] set(byte[] key, byte[] value, Duration expired);

	Long mdel(byte[]... keys);

	List<byte[]> mget(byte[]... keys);
	
	byte[] del(byte[] key);

	Set<byte[]> keys(byte[] pattern);

	default Long size(byte[] pattern) {
		return (long) keys(pattern).size();
	}

}