/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis;

import java.time.Duration;

public interface Constant {
    public static final int DEFAULT_DEL_BATCH_SIZE = 5000;
    public static final int DEFAULT_SCAN_BATCH_SIZE = 3000;
    public static final int DEFAULT_FETCH_BATCH_SIZE = 50;
    public static final String GETDEL = "if redis.call('exists', KEYS[1]) > 0 then local value = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return value else local r; return r end";
    public static final String GETSET = "local previous = redis.call('get', KEYS[1]); redis.call('psetex', KEYS[1], ARGV[2], ARGV[1]); return previous";
    public static final String DEFAULT_CACHE_KEY_PREFIX = "shiro:cache:";
    public static final Duration DEFAULT_CACHE_EXPIRATION = Duration.ofMinutes(30L);

    public static enum Select {
        GET("redis.call('select', ARGV[1]); return redis.call('get', KEYS[1])"),
        GETSET("redis.call('select', ARGV[3]);local previous = redis.call('get', KEYS[1]); redis.call('psetex', KEYS[1], ARGV[2], ARGV[1]); return previous"),
        GETDEL("redis.call('select', ARGV[1]);if redis.call('exists', KEYS[1]) > 0 then local value = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return value else local r; return r end"),
        MGET("redis.call('select', ARGV[1]); return redis.call('mget', unpack(KEYS))"),
        DEL("redis.call('select', ARGV[1]); return redis.call('del', unpack(KEYS))"),
        UNLINK("redis.call('select', ARGV[1]); return redis.call('unlink', unpack(KEYS))"),
        SCAN("redis.call('select', ARGV[4]); return redis.call('scan', ARGV[1], 'MATCH', ARGV[2], 'COUNT', ARGV[3])");

        private final String command;

        private Select(String command) {
            this.command = command;
        }

        public String command() {
            return this.command;
        }
    }
}

