/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.iherus.shiro.util.Utils;

public class HostPortPair
implements Serializable {
    private static final long serialVersionUID = 8603816125320062450L;
    private static final String PROTOCOL_REDIS = "redis://";
    private static final String PROTOCOL_REDISS = "rediss://";
    private String host;
    private int port;

    protected HostPortPair() {
    }

    public HostPortPair(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Utils.nullSafeHashCode(this.host);
        result = 31 * result + Utils.nullSafeHashCode(this.port);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof HostPortPair)) {
            return false;
        }
        HostPortPair other = (HostPortPair)obj;
        if (!Utils.nullSafeEquals(this.host, other.host)) {
            return false;
        }
        return Utils.nullSafeEquals(this.port, other.port);
    }

    public String toString() {
        return this.host + ":" + this.port;
    }

    public String toStringWithProtocol(boolean ssl) {
        return (ssl ? PROTOCOL_REDISS : PROTOCOL_REDIS) + this.toString();
    }

    public static Set<String> convertToStringPairs(Set<HostPortPair> pairs, boolean withProtocol, boolean ... ssl) {
        if (pairs == null || pairs.isEmpty()) {
            return Collections.emptySet();
        }
        boolean sslToUse = ssl != null && ssl.length > 0 ? ssl[0] : false;
        LinkedHashSet<String> textPairs = new LinkedHashSet<String>(pairs.size());
        for (HostPortPair pair : pairs) {
            if (pair == null || ":".equals(pair.toString().trim())) continue;
            if (withProtocol) {
                textPairs.add((sslToUse ? PROTOCOL_REDISS : PROTOCOL_REDIS) + pair.toString());
                continue;
            }
            textPairs.add(pair.toString());
        }
        return Collections.unmodifiableSet(textPairs);
    }
}

