/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.config;

import java.util.Set;
import org.iherus.shiro.cache.redis.config.HostPortPair;
import org.iherus.shiro.cache.redis.config.RedisStandaloneConfiguration;

public interface RedisConfiguration {
    public static final RedisConfiguration defaulted = new RedisStandaloneConfiguration();

    default public String getPassword() {
        return null;
    }

    public Set<String> getAddresses(boolean var1);

    public static boolean isSentinelConfiguration(RedisConfiguration configuration) {
        return configuration instanceof SentinelConfiguration;
    }

    public static boolean isClusterConfiguration(RedisConfiguration configuration) {
        return configuration instanceof ClusterConfiguration;
    }

    public static interface ClusterConfiguration {
        public Set<HostPortPair> getClusterNodes();

        public int getMaxAttempts();
    }

    public static interface SentinelConfiguration
    extends DatabaseConfiguration {
        public String getMasterName();

        public Set<HostPortPair> getSentinels();
    }

    public static interface StandaloneConfiguration
    extends DatabaseConfiguration {
        public String getHost();

        public int getPort();
    }

    public static interface DatabaseConfiguration {
        default public int getDatabase() {
            return 0;
        }
    }
}

