/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.iherus.shiro.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRedisConnection {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRedisConnection.class);
    public static final String EMPTY_STRING = "";
    private static final String SERVER_VERSION_PATTERN = "redis_version:(.*?)\\r\\n";
    private static volatile ExecutorService executor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ExecutorService defaultExecutor() {
        if (executor != null) return executor;
        Class<AbstractRedisConnection> clazz = AbstractRedisConnection.class;
        synchronized (AbstractRedisConnection.class) {
            if (executor != null) return executor;
            executor = AbstractRedisConnection.createDefaultExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return executor;
        }
    }

    private static ExecutorService createDefaultExecutor() {
        int coreThreads = Runtime.getRuntime().availableProcessors();
        int queueSize = 1024;
        return new ThreadPoolExecutor(coreThreads, coreThreads * 2, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), new ControllableRunsPolicy());
    }

    protected String parseServerVersion(String content) {
        if (Utils.isBlank(content)) {
            return EMPTY_STRING;
        }
        Pattern pattern = Pattern.compile(SERVER_VERSION_PATTERN);
        Matcher matcher = pattern.matcher(content);
        try {
            if (matcher.find()) {
                return matcher.group(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return EMPTY_STRING;
    }

    protected Long batchDeleteOnStandalone(int batchSize, byte[][] keys, Function<byte[][], Long> executor) {
        List keyList = Arrays.asList(keys);
        long count = 0L;
        int index = 0;
        int batchCount = keys.length % batchSize == 0 ? keys.length / batchSize : keys.length / batchSize + 1;
        for (int i = 0; i < batchCount; ++i) {
            int batchSizeToUse = Math.min(keys.length - index, batchSize);
            List batchKeyList = keyList.subList(index, index + batchSizeToUse);
            index += batchSizeToUse;
            byte[][] batchKeys = (byte[][])batchKeyList.toArray((T[])new byte[batchKeyList.size()][]);
            count += Optional.ofNullable(executor.apply(batchKeys)).orElse(0L).longValue();
        }
        return count;
    }

    protected List<byte[]> batchGetOnStandalone(int batchSize, byte[][] keys, Function<byte[][], List<byte[]>> executor) {
        List keyList = Arrays.asList(keys);
        int index = 0;
        int batchCount = keys.length % batchSize == 0 ? keys.length / batchSize : keys.length / batchSize + 1;
        ArrayList values = new ArrayList(keys.length);
        for (int i = 0; i < batchCount; ++i) {
            int batchSizeToUse = Math.min(keys.length - index, batchSize);
            List batchKeyList = keyList.subList(index, index + batchSizeToUse);
            index += batchSizeToUse;
            byte[][] batchKeys = (byte[][])batchKeyList.toArray((T[])new byte[batchKeyList.size()][]);
            values.addAll(Optional.ofNullable(executor.apply(batchKeys)).orElse(Collections.emptyList()));
        }
        return Collections.unmodifiableList(values);
    }

    protected Long batchDeleteOnCluster(int batchSize, byte[][] keys, Function<byte[][], Long> executor, Function<byte[], Integer> calculator) {
        Map<Integer, Set<byte[]>> keysMap = this.getClassifiedKeys(calculator, keys);
        if (keysMap.isEmpty()) {
            return 0L;
        }
        AtomicLong size = new AtomicLong(0L);
        keysMap.forEach((slot, keySet) -> {
            byte[][] keysOfSlot = (byte[][])keySet.toArray((T[])new byte[keySet.size()][]);
            size.getAndAdd(Optional.ofNullable(executor.apply(keysOfSlot)).orElse(0L));
        });
        return size.get();
    }

    protected List<byte[]> batchGetOnCluster(int batchSize, byte[][] keys, Function<byte[][], List<byte[]>> executor, Function<byte[], Integer> calculator) {
        Map<Integer, Set<byte[]>> keysMap = this.getClassifiedKeys(calculator, keys);
        if (keysMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList values = new ArrayList(keys.length);
        keysMap.forEach((slot, keySet) -> {
            byte[][] keysOfSlot = (byte[][])keySet.toArray((T[])new byte[keySet.size()][]);
            values.addAll(this.batchGetOnStandalone(batchSize, keysOfSlot, executor));
        });
        return Collections.unmodifiableList(values);
    }

    protected Map<Integer, Set<byte[]>> getClassifiedKeys(Function<byte[], Integer> calculator, byte[] ... keys) {
        HashMap<Integer, HashSet<byte[]>> keysMap = new HashMap<Integer, HashSet<byte[]>>();
        if (!Utils.isEmpty(keys)) {
            for (byte[] key : keys) {
                if (Utils.isEmpty(key)) continue;
                int slot = Optional.ofNullable(calculator.apply(key)).orElse(0);
                if (keysMap.containsKey(slot)) {
                    ((Set)keysMap.get(slot)).add(key);
                    continue;
                }
                keysMap.put(slot, new HashSet<byte[]>(Collections.singleton(key)));
            }
        }
        return Collections.unmodifiableMap(keysMap);
    }

    protected Set<byte[]> distributionScanKeys(Function<CompletionService<Set<byte[]>>, Integer> forkExecutor) {
        HashSet keys = new HashSet();
        ExecutorCompletionService completionService = new ExecutorCompletionService(this.getExecutor());
        int taskSize = Optional.ofNullable(forkExecutor.apply(completionService)).orElse(0);
        for (int i = 0; i < taskSize; ++i) {
            Set keysOfNode = Collections.emptySet();
            try {
                keysOfNode = (Set)completionService.take().get();
            }
            catch (Exception e) {
                logger.warn("Redis cluster's keys scan sub-threads cannot execute normally", (Throwable)e);
            }
            keys.addAll(keysOfNode);
        }
        return Collections.unmodifiableSet(keys);
    }

    protected ExecutorService getExecutor() {
        return AbstractRedisConnection.defaultExecutor();
    }

    static class ControllableRunsPolicy
    implements RejectedExecutionHandler {
        private final float memoryBarrierFactor = 0.85f;
        private final AtomicLong counter = new AtomicLong(0L);

        ControllableRunsPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            Runtime runtime = Runtime.getRuntime();
            long barrier = (long)((float)runtime.maxMemory() * 0.85f);
            if (runtime.totalMemory() < barrier) {
                Thread t = new Thread(r, "T-Shiro-Redis-Rejected-RunAlone-" + this.counter.incrementAndGet());
                if (logger.isInfoEnabled()) {
                    logger.info("Thread [ {} ] runs in the reject policy.", (Object)t.getName());
                }
                t.start();
            } else if (!executor.isShutdown()) {
                r.run();
            }
        }
    }
}

