/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.jedis;

import java.util.HashSet;
import java.util.Set;
import org.iherus.shiro.cache.redis.connection.AbstractRedisConnection;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public abstract class AbstractJedisConnection
extends AbstractRedisConnection {
    public Set<byte[]> scanKeys(Jedis connection, byte[] pattern, int batchSize) {
        ScanResult scanResult;
        HashSet<byte[]> keys = new HashSet<byte[]>();
        ScanParams params = new ScanParams();
        params.count(Integer.valueOf(batchSize));
        params.match(pattern);
        byte[] cursor = ScanParams.SCAN_POINTER_START_BINARY;
        do {
            scanResult = connection.scan(cursor, params);
            keys.addAll(scanResult.getResult());
            cursor = scanResult.getCursorAsBytes();
        } while (scanResult.getCursor().compareTo(ScanParams.SCAN_POINTER_START) > 0);
        return keys;
    }

    public boolean isMaster(Jedis connection) {
        return connection.info("Replication").contains("role:master");
    }

    public void releaseConnection(Jedis connection) {
        if (connection != null) {
            connection.close();
        }
    }
}

