/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.jedis;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.iherus.shiro.cache.redis.connection.BatchOptions;
import org.iherus.shiro.cache.redis.connection.RedisConnection;
import org.iherus.shiro.cache.redis.connection.jedis.AbstractJedisConnection;
import org.iherus.shiro.util.RedisVerUtils;
import org.iherus.shiro.util.Utils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.util.JedisClusterCRC16;
import redis.clients.jedis.util.SafeEncoder;

public class JedisClusterConnection
extends AbstractJedisConnection
implements RedisConnection {
    private final JedisCluster cluster;
    private final BatchOptions options;
    private static final Function<byte[], Integer> calculator = key -> JedisClusterCRC16.getSlot((byte[])key);

    public JedisClusterConnection(JedisCluster cluster) {
        this(cluster, BatchOptions.defaulted);
    }

    public JedisClusterConnection(JedisCluster cluster, BatchOptions options) {
        this.cluster = cluster;
        this.options = options;
    }

    public JedisCluster getCluster() {
        return this.cluster;
    }

    public BatchOptions getOptions() {
        return this.options;
    }

    @Override
    public byte[] get(byte[] key) {
        return this.getCluster().get(key);
    }

    @Override
    public byte[] set(byte[] key, byte[] value, Duration expired) {
        List args = Arrays.asList(value, Utils.longToBytes(expired.toMillis()));
        return (byte[])this.getCluster().eval(SafeEncoder.encode((String)"local previous = redis.call('get', KEYS[1]); redis.call('psetex', KEYS[1], ARGV[2], ARGV[1]); return previous"), Collections.singletonList(key), args);
    }

    @Override
    public Long mdel(byte[] ... keys) {
        if (Utils.isEmpty(keys)) {
            return 0L;
        }
        boolean unlink = RedisVerUtils.getServerVersion(() -> {
            JedisPool pool = (JedisPool)this.getCluster().getClusterNodes().values().iterator().next();
            return this.parseServerVersion(pool.getResource().info("Server"));
        }).isSupportUnlink();
        return this.batchDeleteOnCluster(this.options.getDeleteBatchSize(), keys, batchKeys -> unlink ? this.getCluster().unlink(batchKeys) : this.getCluster().del(batchKeys), calculator);
    }

    @Override
    public List<byte[]> mget(byte[] ... keys) {
        return this.batchGetOnCluster(this.options.getFetchBatchSize(), keys, batchKeys -> this.getCluster().mget(batchKeys), calculator);
    }

    @Override
    public byte[] del(byte[] key) {
        return (byte[])this.getCluster().eval(SafeEncoder.encode((String)"if redis.call('exists', KEYS[1]) > 0 then local value = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return value else local r; return r end"), 1, (byte[][])new byte[][]{key});
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        return this.distributionScanKeys(completion -> {
            Map nodes = this.getCluster().getClusterNodes();
            nodes.forEach((key, pool) -> completion.submit(() -> this.getKeysFromNode((JedisPool)pool, pattern)));
            return nodes.size();
        });
    }

    @Override
    public boolean isClusterConnection() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<byte[]> getKeysFromNode(JedisPool pool, byte[] pattern) {
        Jedis connection = null;
        try {
            Set<byte[]> keys;
            connection = pool.getResource();
            if (!this.isMaster(connection)) {
                Set<byte[]> set = Collections.emptySet();
                return set;
            }
            Set<byte[]> set = keys = this.scanKeys(connection, pattern, this.options.getScanBatchSize());
            return set;
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    @Override
    public void close() {
    }
}

