/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.jedis;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.iherus.shiro.cache.redis.connection.BatchOptions;
import org.iherus.shiro.cache.redis.connection.RedisConnection;
import org.iherus.shiro.cache.redis.connection.jedis.AbstractJedisConnection;
import org.iherus.shiro.util.RedisVerUtils;
import org.iherus.shiro.util.Utils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.util.SafeEncoder;

public class JedisConnection
extends AbstractJedisConnection
implements RedisConnection {
    private final Jedis jedis;
    private final BatchOptions options;
    private Optional<Integer> database = Optional.empty();

    public JedisConnection(Jedis jedis) {
        this(jedis, BatchOptions.defaulted);
    }

    public JedisConnection(Jedis jedis, BatchOptions options) {
        this.jedis = jedis;
        this.options = options;
    }

    public Jedis getJedis() {
        return this.jedis;
    }

    public Optional<Integer> getDatabase() {
        return this.database;
    }

    public void setDatabase(Integer database) {
        this.database = Optional.ofNullable(database == null ? null : Integer.valueOf(Math.max(0, database)));
    }

    public BatchOptions getOptions() {
        return this.options;
    }

    protected Jedis getCommandExecutor() {
        this.getDatabase().filter(db -> db.intValue() != this.jedis.getDB()).ifPresent(arg_0 -> ((Jedis)this.jedis).select(arg_0));
        return this.jedis;
    }

    @Override
    public byte[] get(byte[] key) {
        return this.getCommandExecutor().get(key);
    }

    @Override
    public byte[] set(byte[] key, byte[] value, Duration expired) {
        List args = Arrays.asList(value, Utils.longToBytes(expired.toMillis()));
        return (byte[])this.getCommandExecutor().eval(SafeEncoder.encode((String)"local previous = redis.call('get', KEYS[1]); redis.call('psetex', KEYS[1], ARGV[2], ARGV[1]); return previous"), Collections.singletonList(key), args);
    }

    @Override
    public Long mdel(byte[] ... keys) {
        if (Utils.isEmpty(keys)) {
            return 0L;
        }
        boolean unlink = RedisVerUtils.getServerVersion(() -> this.parseServerVersion(this.getJedis().info("Server"))).isSupportUnlink();
        return this.batchDeleteOnStandalone(this.options.getDeleteBatchSize(), keys, batchKeys -> unlink ? this.getCommandExecutor().unlink(batchKeys) : this.getCommandExecutor().del(batchKeys));
    }

    @Override
    public List<byte[]> mget(byte[] ... keys) {
        return this.batchGetOnStandalone(this.options.getFetchBatchSize(), keys, batchKeys -> this.getCommandExecutor().mget(batchKeys));
    }

    @Override
    public byte[] del(byte[] key) {
        return (byte[])this.getCommandExecutor().eval(SafeEncoder.encode((String)"if redis.call('exists', KEYS[1]) > 0 then local value = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return value else local r; return r end"), 1, (byte[][])new byte[][]{key});
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        return this.scanKeys(this.getCommandExecutor(), pattern, this.options.getScanBatchSize());
    }

    @Override
    public void close() {
        this.releaseConnection(this.getJedis());
    }
}

