/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.lettuce;

import io.lettuce.core.KeyScanCursor;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScanCursor;
import io.lettuce.core.api.sync.RedisCommands;
import java.util.HashSet;
import java.util.Set;
import org.iherus.shiro.cache.redis.connection.AbstractRedisConnection;
import org.iherus.shiro.cache.redis.serializer.StringSerializer;

public abstract class AbstractLettuceConnection
extends AbstractRedisConnection {
    public Set<byte[]> scanKeys(RedisCommands<byte[], byte[]> connection, byte[] pattern, int batchSize) {
        KeyScanCursor cursorOfPerBatch;
        HashSet<byte[]> keys = new HashSet<byte[]>();
        ScanArgs args = ScanArgs.Builder.matches((String)StringSerializer.UTF_8.deserialize(pattern)).limit((long)batchSize);
        ScanCursor cursor = ScanCursor.INITIAL;
        do {
            cursorOfPerBatch = connection.scan(cursor, args);
            keys.addAll(cursorOfPerBatch.getKeys());
        } while (!(cursor = new ScanCursor(cursorOfPerBatch.getCursor(), cursorOfPerBatch.isFinished())).isFinished());
        return keys;
    }
}

