/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.support.AsyncConnectionPoolSupport;
import io.lettuce.core.support.AsyncPool;
import io.lettuce.core.support.BoundedPoolConfig;
import io.lettuce.core.support.CommonsPool2ConfigConverter;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.iherus.shiro.cache.redis.connection.Destroyable;
import org.iherus.shiro.cache.redis.connection.lettuce.ConnectionProvider;
import org.iherus.shiro.cache.redis.connection.lettuce.Futures;
import org.iherus.shiro.cache.redis.connection.lettuce.StandaloneConnectionProvider;
import org.iherus.shiro.exception.ConnectionPoolException;
import org.iherus.shiro.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnectionPool
implements ConnectionProvider,
Destroyable {
    @Override
    public abstract <T extends StatefulConnection<?, ?>> T getConnection(Class<T> var1);

    @Override
    public abstract <T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> var1);

    @Override
    public abstract void release(StatefulConnection<?, ?> var1);

    @Override
    public abstract CompletableFuture<Void> releaseAsync(StatefulConnection<?, ?> var1);

    private static class LettucePooledObjectFactory<T extends StatefulConnection<?, ?>>
    extends BasePooledObjectFactory<T> {
        private final ConnectionProvider connectionProvider;
        private final Supplier<Class<T>> conditionSupplier;

        LettucePooledObjectFactory(ConnectionProvider connectionProvider, Supplier<Class<T>> conditionSupplier) {
            this.connectionProvider = connectionProvider;
            this.conditionSupplier = conditionSupplier;
        }

        public T create() throws Exception {
            return this.connectionProvider.getConnection(this.conditionSupplier.get());
        }

        public void destroyObject(PooledObject<T> p) throws Exception {
            ((StatefulConnection)p.getObject()).close();
        }

        public PooledObject<T> wrap(T obj) {
            return new DefaultPooledObject(obj);
        }

        public void activateObject(PooledObject<T> p) throws Exception {
            StatefulConnection object = (StatefulConnection)p.getObject();
            if (object instanceof StatefulRedisConnection && this.connectionProvider instanceof StandaloneConnectionProvider.DatabaseProvider) {
                Integer db = Utils.getFieldValue(object, "db", Integer.class);
                int database = ((StandaloneConnectionProvider.DatabaseProvider)((Object)this.connectionProvider)).getDatabase();
                if (db != null && db != database) {
                    ((StatefulRedisConnection)object).sync().select(database);
                }
            }
        }

        public boolean validateObject(PooledObject<T> p) {
            return ((StatefulConnection)p.getObject()).isOpen();
        }
    }

    static class LettuceSmartConnectionPool
    extends ConnectionPool
    implements ConnectionProvider.ClientProvider {
        private static final Logger logger = LoggerFactory.getLogger(LettuceSmartConnectionPool.class);
        private final ConnectionProvider nativeConnectionProvider;
        private final GenericObjectPoolConfig poolConfig;
        private final BoundedPoolConfig asyncPoolConfig;
        private final Map<StatefulConnection<?, ?>, GenericObjectPool<StatefulConnection<?, ?>>> poolRef = new ConcurrentHashMap(32);
        private final Map<StatefulConnection<?, ?>, AsyncPool<StatefulConnection<?, ?>>> asyncPoolRef = new ConcurrentHashMap(32);
        private final Map<CompletableFuture<StatefulConnection<?, ?>>, AsyncPool<StatefulConnection<?, ?>>> inProgressAsyncPoolRef = new ConcurrentHashMap(32);
        private final Map<Class<?>, GenericObjectPool<StatefulConnection<?, ?>>> pools = new ConcurrentHashMap(32);
        private final Map<Class<?>, AsyncPool<StatefulConnection<?, ?>>> asyncPools = new ConcurrentHashMap(32);

        LettuceSmartConnectionPool(ConnectionProvider connectionProvider, GenericObjectPoolConfig poolConfig) {
            Utils.assertNotNull(connectionProvider, "Native connection-provider must not be null.");
            Utils.assertNotNull(poolConfig, "GenericObjectPoolConfig must not be null.");
            this.nativeConnectionProvider = connectionProvider;
            this.poolConfig = poolConfig;
            this.asyncPoolConfig = CommonsPool2ConfigConverter.bounded((GenericObjectPoolConfig)this.poolConfig);
        }

        @Override
        public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType) {
            GenericObjectPool pool = this.pools.computeIfAbsent(connectionType, poolType -> new GenericObjectPool(new LettucePooledObjectFactory(this.nativeConnectionProvider, () -> connectionType), this.poolConfig));
            try {
                StatefulConnection connection = (StatefulConnection)pool.borrowObject();
                this.poolRef.put(connection, pool);
                return (T)((StatefulConnection)connectionType.cast(connection));
            }
            catch (Exception e) {
                throw new ConnectionPoolException("Could not get a resource from the pool", e);
            }
        }

        @Override
        public <T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> connectionType) {
            AsyncPool pool = this.asyncPools.computeIfAbsent(connectionType, poolType -> AsyncConnectionPoolSupport.createBoundedObjectPool(() -> this.nativeConnectionProvider.getConnectionAsync(connectionType).thenApply(connectionType::cast), (BoundedPoolConfig)this.asyncPoolConfig, (boolean)false));
            CompletableFuture acquire = pool.acquire();
            this.inProgressAsyncPoolRef.put(acquire, pool);
            return ((CompletableFuture)acquire.whenComplete((connection, e) -> {
                this.inProgressAsyncPoolRef.remove(acquire);
                if (connection != null) {
                    this.asyncPoolRef.put((StatefulConnection<?, ?>)connection, (AsyncPool<StatefulConnection<?, ?>>)pool);
                }
            })).thenApply(connectionType::cast);
        }

        @Override
        public void release(StatefulConnection<?, ?> connection) {
            GenericObjectPool<StatefulConnection<?, ?>> pool = this.poolRef.remove(connection);
            if (pool == null) {
                AsyncPool<StatefulConnection<?, ?>> asyncPool = this.asyncPoolRef.remove(connection);
                if (asyncPool == null) {
                    throw new ConnectionPoolException("Returned connection " + connection + " was either previously returned or does not belong to this connection provider");
                }
                this.discardIfNecessary(connection);
                asyncPool.release(connection).join();
                return;
            }
            this.discardIfNecessary(connection);
            pool.returnObject(connection);
        }

        private void discardIfNecessary(StatefulConnection<?, ?> connection) {
            StatefulRedisConnection redisConnection;
            if (connection instanceof StatefulRedisConnection && (redisConnection = (StatefulRedisConnection)connection).isMulti()) {
                redisConnection.async().discard();
            }
        }

        @Override
        public CompletableFuture<Void> releaseAsync(StatefulConnection<?, ?> connection) {
            GenericObjectPool<StatefulConnection<?, ?>> blockingPool = this.poolRef.remove(connection);
            if (blockingPool != null) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Releasing asynchronously a connection that was obtained from a non-blocking pool");
                }
                blockingPool.returnObject(connection);
                return CompletableFuture.completedFuture(null);
            }
            AsyncPool<StatefulConnection<?, ?>> pool = this.asyncPoolRef.remove(connection);
            if (pool == null) {
                return Futures.failed(new ConnectionPoolException("Returned connection " + connection + " was either previously returned or does not belong to this connection provider"));
            }
            return pool.release(connection);
        }

        @Override
        public AbstractRedisClient getClient() {
            if (this.nativeConnectionProvider instanceof ConnectionProvider.ClientProvider) {
                return ((ConnectionProvider.ClientProvider)((Object)this.nativeConnectionProvider)).getClient();
            }
            throw new IllegalStateException(String.format("Underlying connection provider %s does not implement ClientProvider.", this.nativeConnectionProvider.getClass().getName()));
        }

        @Override
        public void destroy() throws Exception {
            ArrayList futures = new ArrayList();
            if (!(this.poolRef.isEmpty() && this.asyncPoolRef.isEmpty() || !logger.isWarnEnabled())) {
                logger.warn("LettuceSmartConnectionPool contains unreleased connections.");
            }
            if (!this.inProgressAsyncPoolRef.isEmpty()) {
                if (logger.isWarnEnabled()) {
                    logger.warn("LettuceSmartConnectionPool has active connection retrievals.");
                }
                this.inProgressAsyncPoolRef.forEach((k, v) -> futures.add(k.thenApply(StatefulConnection::closeAsync)));
            }
            if (!this.poolRef.isEmpty()) {
                this.poolRef.forEach((connection, pool) -> pool.returnObject(connection));
                this.poolRef.clear();
            }
            if (!this.asyncPoolRef.isEmpty()) {
                this.asyncPoolRef.forEach((connection, pool) -> futures.add(pool.release(connection)));
                this.asyncPoolRef.clear();
            }
            this.pools.forEach((type, pool) -> pool.close());
            ((CompletableFuture)((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])futures.stream().map(it -> it.exceptionally(e -> null)).toArray(CompletableFuture[]::new)).thenCompose(ignored -> {
                CompletableFuture[] poolClose = (CompletableFuture[])this.asyncPools.values().stream().map(AsyncPool::closeAsync).map(it -> it.exceptionally(e -> null)).toArray(CompletableFuture[]::new);
                return CompletableFuture.allOf(poolClose);
            })).thenRun(() -> {
                this.asyncPoolRef.clear();
                this.inProgressAsyncPoolRef.clear();
            })).join();
            this.pools.clear();
        }
    }
}

