/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.api.StatefulConnection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.iherus.shiro.cache.redis.connection.lettuce.Futures;

@FunctionalInterface
public interface ConnectionProvider {
    default public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType) {
        return (T)((StatefulConnection)Futures.join(this.getConnectionAsync(connectionType).toCompletableFuture()));
    }

    public <T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> var1);

    default public void release(StatefulConnection<?, ?> connection) {
        connection.close();
    }

    default public CompletableFuture<Void> releaseAsync(StatefulConnection<?, ?> connection) {
        return connection.closeAsync();
    }

    public static interface ClientProvider {
        public AbstractRedisClient getClient();
    }
}

