/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.pubsub.StatefulRedisClusterPubSubConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.iherus.shiro.cache.redis.connection.lettuce.ConnectionProvider;
import org.iherus.shiro.cache.redis.connection.lettuce.Futures;
import org.iherus.shiro.util.Utils;

public class LettuceClusterConnectionProvider
implements ConnectionProvider,
ConnectionProvider.ClientProvider {
    private final RedisClusterClient client;
    private final RedisCodec<?, ?> codec;
    private final Optional<ReadFrom> readFrom;
    private volatile boolean initialized;
    private final Object lock = new Object();

    public LettuceClusterConnectionProvider(RedisClusterClient client, RedisCodec<?, ?> codec) {
        this(client, codec, null);
    }

    public LettuceClusterConnectionProvider(RedisClusterClient client, RedisCodec<?, ?> codec, ReadFrom readFrom) {
        Utils.assertNotNull(client, "Cluster client must not be null.");
        Utils.assertNotNull(codec, "Codec must not be null.");
        this.client = client;
        this.codec = codec;
        this.readFrom = Optional.ofNullable(readFrom);
    }

    @Override
    public AbstractRedisClient getClient() {
        return this.client;
    }

    @Override
    public <T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> connectionType) {
        block5: {
            block4: {
                this.initializePartitions();
                if (StatefulRedisClusterPubSubConnection.class.isAssignableFrom(connectionType)) break block4;
                if (!StatefulRedisPubSubConnection.class.equals(connectionType)) break block5;
            }
            return this.client.connectPubSubAsync(this.codec).thenApply(connectionType::cast);
        }
        if (StatefulRedisClusterConnection.class.isAssignableFrom(connectionType) || StatefulConnection.class.equals(connectionType)) {
            return this.client.connectAsync(this.codec).thenApply(connection -> {
                this.readFrom.ifPresent(arg_0 -> ((StatefulRedisClusterConnection)connection).setReadFrom(arg_0));
                return (StatefulConnection)connectionType.cast(connection);
            });
        }
        return Futures.failed(new UnsupportedOperationException(String.format("Connection type {%s} is not supported in the current provider.", connectionType)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializePartitions() {
        if (!this.initialized) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.initialized) {
                    this.client.getPartitions();
                    this.initialized = true;
                }
            }
        }
    }
}

