/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.redisson;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.iherus.shiro.cache.redis.Constant;
import org.iherus.shiro.cache.redis.connection.AbstractRedisConnection;
import org.iherus.shiro.util.Utils;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.command.CommandExecutor;
import org.redisson.connection.MasterSlaveEntry;

public abstract class AbstractRedissonConnection
extends AbstractRedisConnection {
    protected abstract CommandExecutor getCommandExecutor();

    public Iterator<byte[]> scanKeys(final MasterSlaveEntry entry, final byte[] pattern, final int batchSize) {
        return new ByteArrayIterator(){

            @Override
            protected ScanResult<byte[]> iterator(RedisClient client, long nextIterPos) {
                return (ScanResult)AbstractRedissonConnection.this.getCommandExecutor().get(AbstractRedissonConnection.this.scanAsync(client, entry, nextIterPos, pattern, batchSize));
            }
        };
    }

    private RFuture<ListScanResult<byte[]>> scanAsync(RedisClient client, MasterSlaveEntry entry, long startPos, byte[] pattern, int count) {
        return this.getCommandExecutor().readAsync(client, entry, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.SCAN, new Object[]{startPos, "MATCH", pattern, "COUNT", count});
    }

    public Set<byte[]> scanKeysOnDb(MasterSlaveEntry entry, int db, byte[] pattern, int batchSize) {
        HashSet<byte[]> keys = new HashSet<byte[]>();
        Utils.MutableArray<Object> mutableArray = Utils.newMutableArray(null, pattern, Utils.intToBytes(batchSize), Utils.intToBytes(db));
        byte[] cursor = Utils.intToBytes(0);
        do {
            Object[] params = mutableArray.replace(0, cursor).toArray();
            RFuture f = this.getCommandExecutor().evalReadAsync(entry, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.EVAL_LIST, Constant.Select.SCAN.command(), Collections.emptyList(), params);
            List objectList = (List)this.getCommandExecutor().get(f);
            cursor = (byte[])objectList.get(0);
            keys.addAll((Collection)objectList.get(1));
        } while (Utils.bytesToText(cursor).compareTo("0") > 0);
        return keys;
    }

    static abstract class ByteArrayIterator
    implements Iterator<byte[]> {
        private Iterator<byte[]> lastIter;
        protected long nextIterPos;
        protected RedisClient client;
        private boolean finished;
        private boolean currentElementRemoved;
        protected byte[] value;

        ByteArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.lastIter == null || !this.lastIter.hasNext()) {
                if (this.finished) {
                    this.currentElementRemoved = false;
                    this.client = null;
                    this.nextIterPos = 0L;
                    if (!this.tryAgain()) {
                        return false;
                    }
                    this.finished = false;
                }
                do {
                    ScanResult<byte[]> res = this.iterator(this.client, this.nextIterPos);
                    this.client = res.getRedisClient();
                    this.lastIter = res.getValues().iterator();
                    this.nextIterPos = res.getPos();
                    if (res.getPos() != 0L) continue;
                    this.finished = true;
                    if (!res.getValues().isEmpty()) continue;
                    this.currentElementRemoved = false;
                    this.client = null;
                    this.nextIterPos = 0L;
                    if (this.tryAgain()) continue;
                    return false;
                } while (!this.lastIter.hasNext());
            }
            return this.lastIter.hasNext();
        }

        protected boolean tryAgain() {
            return false;
        }

        protected abstract ScanResult<byte[]> iterator(RedisClient var1, long var2);

        @Override
        public byte[] next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No such element");
            }
            this.value = this.lastIter.next();
            this.currentElementRemoved = false;
            return this.value;
        }

        @Override
        public void remove() {
            if (this.currentElementRemoved) {
                throw new IllegalStateException("Element been already deleted");
            }
            if (this.lastIter == null || this.value == null) {
                throw new IllegalStateException();
            }
            this.lastIter.remove();
            this.currentElementRemoved = true;
        }
    }
}

