/**
 * Copyright (c) 2016-2021, Bosco.Liao (bosco_liao@126.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.iherus.shiro.cache.redis;

import java.time.Duration;

public interface Constant {

	int DEFAULT_DEL_BATCH_SIZE = 5_000;

	int DEFAULT_SCAN_BATCH_SIZE = 3_000;

	int DEFAULT_FETCH_BATCH_SIZE = 50;

	String GETDEL = "if( redis.call('exists', KEYS[1]) > 0 ) then local value = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return value; else local r; return r; end";

	String GETSET = "local previous = redis.call('get', KEYS[1]); if( 0 > tonumber(ARGV[2]) ) then redis.call('set', KEYS[1], ARGV[1]); else redis.call('psetex', KEYS[1], ARGV[2], ARGV[1]); end return previous";

	/**
	 * Default cache key prefix.
	 */
	String DEFAULT_CACHE_KEY_PREFIX = "shiro:cache:";

	/**
	 * Default cache timeout value, equal to {@code 30} minutes.
	 */
	Duration DEFAULT_CACHE_EXPIRATION = Duration.ofMinutes(30);

	enum Select {

		GET("redis.call('select', ARGV[1]); return redis.call('get', KEYS[1])"),

		GETSET("redis.call('select', ARGV[3]);" + Constant.GETSET),

		GETDEL("redis.call('select', ARGV[1]);" + Constant.GETDEL),

		MGET("redis.call('select', ARGV[1]); return redis.call('mget', unpack(KEYS))"),

		DEL("redis.call('select', ARGV[1]); return redis.call('del', unpack(KEYS))"),

		UNLINK("redis.call('select', ARGV[1]); return redis.call('unlink', unpack(KEYS))"),

		// SCAN cursor MATCH pattern COUNT 1000
		SCAN("redis.call('select', ARGV[4]); return redis.call('scan', ARGV[1], 'MATCH', ARGV[2], 'COUNT', ARGV[3])");

		private final String command;

		Select(String command) {
			this.command = command;
		}

		public String command() {
			return command;
		}

	}

}
