/**
 * Copyright (c) 2016-2021, Bosco.Liao (bosco_liao@126.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.iherus.shiro.cache.redis.connection;

/**
 * Implementation object requires a callback during destruction.
 */
public interface Destroyable {

	/**
	 * Called when this object is being destroyed, allowing any necessary cleanup of internal resources.
	 *
	 * @throws Exception if an exception occurs during object destruction.
	 */
	void destroy() throws Exception;

}