/**
 * Copyright (c) 2016-2021, Bosco.Liao (bosco_liao@126.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.iherus.shiro.cache.redis.connection.jedis;

import java.util.HashSet;
import java.util.Set;

import org.iherus.shiro.cache.redis.connection.AbstractRedisConnection;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

/**
 * AbstractJedisConnection
 * 
 * @author Bosco.Liao
 * @since 2.0.0
 */
public abstract class AbstractJedisConnection extends AbstractRedisConnection {

	public Set<byte[]> scanKeys(Jedis connection, final byte[] pattern, final int batchSize) {
		Set<byte[]> keys = new HashSet<byte[]>();
		ScanParams params = new ScanParams();
		params.count(batchSize);
		params.match(pattern);
		byte[] cursor = ScanParams.SCAN_POINTER_START_BINARY;
		ScanResult<byte[]> scanResult;
		do {
			scanResult = connection.scan(cursor, params);
			keys.addAll(scanResult.getResult()); // Filter duplicate keys.
			cursor = scanResult.getCursorAsBytes();
		} while (scanResult.getCursor().compareTo(ScanParams.SCAN_POINTER_START) > 0);

		return keys;
	}

	public boolean isMaster(Jedis connection) {
		return connection.info("Replication").contains("role:master");
	}

	public void releaseConnection(Jedis connection) {
		if (connection != null) {
			connection.close();
		}
	}

}
