/**
 * Copyright (c) 2016-2021, Bosco.Liao (bosco_liao@126.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.iherus.shiro.cache.redis.connection.lettuce;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

import io.lettuce.core.RedisConnectionException;

/**
 * CompletableFuture 工具类
 * 
 * @author Bosco.Liao
 * @since 2.0.0
 */
public abstract class Futures {

	private Futures() {

	}

	/**
	 * Create a {@link CompletableFuture} that is completed exceptionally with
	 * {@code throwable}.
	 *
	 * @param throwable must not be {@literal null}.
	 * @return the exceptionally completed {@link CompletableFuture}.
	 */
	public static <T> CompletableFuture<T> failed(Throwable throwable) {
		return io.lettuce.core.internal.Futures.failed(throwable);
	}

	/**
	 * Synchronizes a {@link CompletableFuture} result by {@link CompletableFuture#join() waiting until the future is complete}.
	 * 
	 * @param future must not be {@literal null}.
	 * @return Synchronous result.
	 */
	public static <T> T join(CompletableFuture<T> future) {
		try {
			return future.join();
		} catch (Exception e) {
			if (e instanceof CompletionException) {
				throw RedisConnectionException.create(e.getCause());
			}
			throw RedisConnectionException.create(e);
		}
	}

}
