/**
 * Copyright (c) 2016-2021, Bosco.Liao (bosco_liao@126.com).
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.iherus.shiro.cache.redis.connection.lettuce;

import java.util.concurrent.CompletionStage;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;

/**
 * StandaloneConnectionProvider
 * 
 * @author Bosco.Liao
 * @since 2.0.0
 */
public interface StandaloneConnectionProvider extends ConnectionProvider {
	
	/**
	 * {@link RedisClient#connectAsync(io.lettuce.core.codec.RedisCodec, RedisURI)}
	 */
	<T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> connectionType,
			RedisURI redisUri);
	
	/**
	 * {@link RedisClient#connect(io.lettuce.core.codec.RedisCodec, RedisURI)}
	 */
	default <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType, RedisURI redisUri) {
		return Futures.join(getConnectionAsync(connectionType, redisUri).toCompletableFuture());
	}
	
	/**
	 * Gets Setting database.
	 */
	interface DatabaseProvider {
		int getDatabase();
	}

}
