/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.session.Session;
import org.iherus.shiro.util.concurrent.ConcurrentReferenceHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemorySessionCache
implements Cache<Serializable, Session> {
    private static final Logger logger = LoggerFactory.getLogger(MemorySessionCache.class);
    private static final Duration DEFAULT_ALIVE_TIME = Duration.ofMillis(1000L);
    private Duration keepAliveTime = DEFAULT_ALIVE_TIME;
    private final Map<Serializable, ValidationSession> cacheDelegate = new ConcurrentReferenceHashMap<Serializable, ValidationSession>();

    public Duration getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(Duration keepAliveTime) {
        this.keepAliveTime = Optional.ofNullable(keepAliveTime).orElse(DEFAULT_ALIVE_TIME);
    }

    public Session get(Serializable key) throws CacheException {
        if (key == null) {
            return null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Gets a session with key [{}] from the memory cache.", (Object)key);
        }
        ValidationSession current = this.cacheDelegate.getOrDefault(key, ValidationSession.NULL_SESSION);
        if (logger.isDebugEnabled() && current == ValidationSession.NULL_SESSION) {
            logger.debug("The session with key [{}] cannot be found in the memory cache.", (Object)key);
        }
        return current.getSession();
    }

    public Session put(Serializable key, Session session) throws CacheException {
        ValidationSession prev;
        if (logger.isDebugEnabled()) {
            logger.debug("Puts a session with key [{}] to the memory cache.", (Object)key);
        }
        return (prev = this.cacheDelegate.put(key, new ValidationSession(session, LocalDateTime.now().plus(this.keepAliveTime)))) == null ? null : prev.getSession();
    }

    public Session remove(Serializable key) throws CacheException {
        ValidationSession prev;
        if (logger.isDebugEnabled()) {
            logger.debug("Removes a session with key [{}] from the memory cache.", (Object)key);
        }
        return (prev = this.cacheDelegate.remove(key)) == null ? null : prev.getSession();
    }

    public void clear() throws CacheException {
        if (logger.isDebugEnabled()) {
            logger.debug("Clears all sessions from the memory cache.");
        }
        this.cacheDelegate.clear();
    }

    public int size() {
        return this.cacheDelegate.size();
    }

    public Set<Serializable> keys() {
        return Collections.emptySet();
    }

    public Collection<Session> values() {
        return Collections.emptySet();
    }

    private static class ValidationSession {
        static final ValidationSession NULL_SESSION = new ValidationSession(null, null);
        private Session session;
        private LocalDateTime expiredTime;

        ValidationSession(Session session, LocalDateTime expiredTime) {
            this.session = session;
            this.expiredTime = expiredTime;
        }

        Session getSession() {
            return this.isValid() ? this.session : null;
        }

        boolean isValid() {
            return this.session != null && this.expiredTime != null && LocalDateTime.now().isBefore(this.expiredTime);
        }
    }
}

