/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis;

import java.io.Serializable;
import java.time.Duration;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.eis.CachingSessionDAO;
import org.iherus.shiro.cache.redis.ExpiredCache;
import org.iherus.shiro.cache.redis.MemorySessionCache;

public class RedisSessionDAO
extends CachingSessionDAO {
    private Cache<Serializable, Session> l1Cache;
    private boolean l1CacheEnabled;

    public RedisSessionDAO(CacheManager cacheManager) {
        this.setCacheManager(cacheManager);
        this.l1CacheEnabled = true;
        this.l1Cache = new MemorySessionCache();
    }

    public Cache<Serializable, Session> getL1Cache() {
        return this.l1Cache;
    }

    public void setL1Cache(Cache<Serializable, Session> l1Cache) {
        this.l1Cache = l1Cache;
    }

    public boolean isL1CacheEnabled() {
        return this.l1CacheEnabled && this.l1Cache != null;
    }

    public void setL1CacheEnabled(boolean l1CacheEnabled) {
        this.l1CacheEnabled = l1CacheEnabled;
    }

    protected boolean isExpiredCacheAware(Cache cache) {
        return cache instanceof ExpiredCache;
    }

    protected void cache(Session session, Serializable sessionId, Cache<Serializable, Session> cache) {
        if (!this.isExpiredCacheAware(cache)) {
            super.cache(session, sessionId, cache);
        } else {
            Duration expiration = session.getTimeout() <= 0L ? Duration.ZERO : Duration.ofMillis(session.getTimeout());
            ((ExpiredCache)cache).put(sessionId, session, expiration);
        }
        if (this.isL1CacheEnabled()) {
            this.l1Cache.put((Object)sessionId, (Object)session);
        }
    }

    protected void doUpdate(Session session) {
        this.doDelete(session);
    }

    protected void doDelete(Session session) {
        if (session != null && session.getId() != null && this.isL1CacheEnabled()) {
            this.l1Cache.remove((Object)session.getId());
        }
    }

    protected Serializable doCreate(Session session) {
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        return sessionId;
    }

    protected Session getCachedSession(Serializable sessionId, Cache<Serializable, Session> cache) {
        if (this.isL1CacheEnabled()) {
            Session session = (Session)this.l1Cache.get((Object)sessionId);
            if (session == null && (session = super.getCachedSession(sessionId, cache)) != null) {
                this.l1Cache.put((Object)sessionId, (Object)session);
            }
            return session;
        }
        return super.getCachedSession(sessionId, cache);
    }

    protected Session doReadSession(Serializable sessionId) {
        return null;
    }
}

