/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.lettuce;

import io.lettuce.core.RedisURI;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.iherus.shiro.cache.redis.connection.BatchOptions;
import org.iherus.shiro.cache.redis.connection.MutableDatabase;
import org.iherus.shiro.cache.redis.connection.RedisConnection;
import org.iherus.shiro.cache.redis.connection.lettuce.AbstractLettuceConnection;
import org.iherus.shiro.cache.redis.connection.lettuce.ConnectionPool;
import org.iherus.shiro.util.RedisVerUtils;
import org.iherus.shiro.util.Utils;

public class LettuceConnection
extends AbstractLettuceConnection
implements RedisConnection,
MutableDatabase {
    private final ConnectionPool pool;
    private final BatchOptions options;
    private final Duration timeout;
    private Optional<Integer> database = Optional.empty();
    private volatile StatefulRedisConnection<byte[], byte[]> nativeConnection;

    public LettuceConnection(ConnectionPool pool) {
        this(pool, BatchOptions.defaulted, RedisURI.DEFAULT_TIMEOUT_DURATION);
    }

    public LettuceConnection(ConnectionPool pool, BatchOptions options, Duration timeout) {
        this.pool = pool;
        this.options = options;
        this.timeout = timeout;
    }

    public Optional<Integer> getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(Integer database) {
        this.database = Optional.ofNullable(database == null ? null : Integer.valueOf(Math.max(0, database)));
    }

    public BatchOptions getOptions() {
        return this.options;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatefulRedisConnection<byte[], byte[]> getNativeConnection() {
        if (this.nativeConnection == null) {
            LettuceConnection lettuceConnection = this;
            synchronized (lettuceConnection) {
                if (this.nativeConnection == null) {
                    this.nativeConnection = this.pool.getConnection(StatefulRedisConnection.class);
                }
            }
        }
        return this.nativeConnection;
    }

    protected RedisCommands<byte[], byte[]> getCommandExecutor() {
        StatefulRedisConnection<byte[], byte[]> connection = this.getNativeConnection();
        RedisCommands commands = connection.sync();
        commands.setTimeout(this.timeout);
        this.database.ifPresent(arg_0 -> ((RedisCommands)commands).select(arg_0));
        return commands;
    }

    @Override
    public byte[] get(byte[] key) {
        return (byte[])this.getCommandExecutor().get((Object)key);
    }

    @Override
    public byte[] set(byte[] key, byte[] value, Duration expired) {
        return (byte[])this.getCommandExecutor().eval("local previous = redis.call('get', KEYS[1]); if( 0 > tonumber(ARGV[2]) ) then redis.call('set', KEYS[1], ARGV[1]); else redis.call('psetex', KEYS[1], ARGV[2], ARGV[1]); end return previous", ScriptOutputType.VALUE, (Object[])new byte[][]{key}, (Object[])new byte[][]{value, Utils.longToBytes(Duration.ZERO.equals(expired) ? -1L : expired.toMillis())});
    }

    @Override
    public Long mdel(byte[] ... keys) {
        if (Utils.isEmpty(keys)) {
            return 0L;
        }
        boolean unlink = RedisVerUtils.getServerVersion(() -> this.parseServerVersion(this.getCommandExecutor().info("Server"))).isSupportUnlink();
        return this.batchDeleteOnStandalone(this.options.getDeleteBatchSize(), keys, batchKeys -> unlink ? this.getCommandExecutor().unlink((Object[])batchKeys) : this.getCommandExecutor().del((Object[])batchKeys));
    }

    @Override
    public List<byte[]> mget(byte[] ... keys) {
        return this.batchGetOnStandalone(this.options.getFetchBatchSize(), keys, batchKeys -> {
            List kvs = this.getCommandExecutor().mget((Object[])batchKeys);
            return kvs.stream().map(kv -> (byte[])kv.getValue()).collect(Collectors.toList());
        });
    }

    @Override
    public byte[] del(byte[] key) {
        return (byte[])this.getCommandExecutor().eval("if( redis.call('exists', KEYS[1]) > 0 ) then local value = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return value; else local r; return r; end", ScriptOutputType.VALUE, (Object[])new byte[][]{key});
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        return this.scanKeys(this.getCommandExecutor(), pattern, this.options.getScanBatchSize());
    }

    @Override
    public void close() {
        if (this.nativeConnection != null) {
            this.pool.release((StatefulConnection<?, ?>)this.nativeConnection);
        }
    }
}

