/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.pubsub.StatefulRedisClusterPubSubConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.masterreplica.MasterReplica;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.sentinel.api.StatefulRedisSentinelConnection;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.iherus.shiro.cache.redis.connection.lettuce.ConnectionProvider;
import org.iherus.shiro.cache.redis.connection.lettuce.Futures;
import org.iherus.shiro.cache.redis.connection.lettuce.StandaloneConnectionProvider;
import org.iherus.shiro.util.Utils;

public class LettuceStandaloneConnectionProvider
implements StandaloneConnectionProvider,
ConnectionProvider.ClientProvider,
StandaloneConnectionProvider.DatabaseProvider {
    private final RedisClient client;
    private final RedisCodec<?, ?> codec;
    private final Optional<ReadFrom> readFrom;
    private final RedisURI redisUri;

    public LettuceStandaloneConnectionProvider(RedisClient client, RedisCodec<?, ?> codec) {
        this(client, codec, null);
    }

    public LettuceStandaloneConnectionProvider(RedisClient client, RedisCodec<?, ?> codec, ReadFrom readFrom) {
        Utils.assertNotNull(client, "Client must not be null.");
        Utils.assertNotNull(codec, "Codec must not be null.");
        this.client = client;
        this.codec = codec;
        this.readFrom = Optional.ofNullable(readFrom);
        this.redisUri = Utils.getFieldValue(this.client, "redisURI", RedisURI.class);
    }

    @Override
    public AbstractRedisClient getClient() {
        return this.client;
    }

    @Override
    public int getDatabase() {
        return this.redisUri.getDatabase();
    }

    @Override
    public <T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> connectionType) {
        return this.getConnectionAsync(connectionType, this.redisUri);
    }

    @Override
    public <T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> connectionType, RedisURI redisUri) {
        block6: {
            block5: {
                if (StatefulRedisSentinelConnection.class.isAssignableFrom(connectionType)) {
                    return this.client.connectSentinelAsync(this.codec, redisUri).thenApply(connectionType::cast);
                }
                if (StatefulRedisPubSubConnection.class.isAssignableFrom(connectionType) && !StatefulRedisClusterPubSubConnection.class.isAssignableFrom(connectionType)) {
                    return this.client.connectPubSubAsync(this.codec, redisUri).thenApply(connectionType::cast);
                }
                if (StatefulRedisConnection.class.isAssignableFrom(connectionType)) break block5;
                if (!StatefulConnection.class.equals(connectionType)) break block6;
            }
            return this.readFrom.map(rf -> this.masterReplicaConnectionAsync(redisUri, (ReadFrom)rf)).orElseGet(() -> this.client.connectAsync(this.codec, redisUri)).thenApply(connectionType::cast);
        }
        return Futures.failed(new UnsupportedOperationException(String.format("Connection type {%s} is not supported in the current provider.", connectionType)));
    }

    private CompletionStage<StatefulRedisConnection<?, ?>> masterReplicaConnectionAsync(RedisURI redisUri, ReadFrom readFrom) {
        CompletableFuture connection = MasterReplica.connectAsync((RedisClient)this.client, this.codec, (RedisURI)redisUri);
        return connection.thenApply(conn -> {
            conn.setReadFrom(readFrom);
            return conn;
        });
    }
}

