/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.redisson;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.iherus.shiro.cache.redis.Constant;
import org.iherus.shiro.cache.redis.connection.BatchOptions;
import org.iherus.shiro.cache.redis.connection.MutableDatabase;
import org.iherus.shiro.cache.redis.connection.RedisConnection;
import org.iherus.shiro.cache.redis.connection.redisson.AbstractRedissonConnection;
import org.iherus.shiro.util.RedisVerUtils;
import org.iherus.shiro.util.Utils;
import org.redisson.Redisson;
import org.redisson.api.RFuture;
import org.redisson.api.RScript;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandExecutor;
import org.redisson.connection.MasterSlaveEntry;

public class RedissonConnection
extends AbstractRedissonConnection
implements RedisConnection,
MutableDatabase {
    private final Redisson redisson;
    private final BatchOptions options;
    private Optional<Integer> database = Optional.empty();

    public RedissonConnection(RedissonClient client) {
        this(client, BatchOptions.defaulted);
    }

    public RedissonConnection(RedissonClient client, BatchOptions options) {
        this.redisson = (Redisson)client;
        this.options = options;
    }

    public Optional<Integer> getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(Integer database) {
        this.database = Optional.ofNullable(database == null ? null : Integer.valueOf(Math.max(0, database)));
    }

    protected boolean isSwitchDb() {
        int nativeDb = this.redisson.getConnectionManager().getConfig().getDatabase();
        return this.getDatabase().filter(db -> db != nativeDb).isPresent();
    }

    public Redisson getRedisson() {
        return this.redisson;
    }

    public BatchOptions getOptions() {
        return this.options;
    }

    @Override
    protected CommandExecutor getCommandExecutor() {
        return this.redisson.getCommandExecutor();
    }

    @Override
    public byte[] get(byte[] key) {
        boolean isSwitchDb = this.isSwitchDb();
        RFuture f = null;
        f = isSwitchDb ? this.getCommandExecutor().evalReadAsync("", (Codec)ByteArrayCodec.INSTANCE, RedisCommands.EVAL_OBJECT, Constant.Select.GET.command(), Collections.singletonList(key), new Object[]{Utils.intToBytes(this.getDatabase().get())}) : this.getCommandExecutor().readAsync(key, (Codec)ByteArrayCodec.INSTANCE, RedisCommands.GET, new Object[]{key});
        return (byte[])this.getCommandExecutor().get(f);
    }

    @Override
    public byte[] set(byte[] key, byte[] value, Duration expired) {
        boolean isSwitchDb = this.isSwitchDb();
        RScript script = this.redisson.getScript((Codec)ByteArrayCodec.INSTANCE);
        Object[] params = Utils.newMutableArray(value, Utils.longToBytes(Duration.ZERO.equals(expired) ? -1L : expired.toMillis())).add(isSwitchDb, () -> Utils.intToBytes(this.getDatabase().get())).toArray();
        RFuture f = script.evalAsync(RScript.Mode.READ_WRITE, isSwitchDb ? Constant.Select.GETSET.command() : "local previous = redis.call('get', KEYS[1]); if( 0 > tonumber(ARGV[2]) ) then redis.call('set', KEYS[1], ARGV[1]); else redis.call('psetex', KEYS[1], ARGV[2], ARGV[1]); end return previous", RScript.ReturnType.VALUE, Collections.singletonList(key), params);
        return (byte[])this.getCommandExecutor().get(f);
    }

    @Override
    public Long mdel(byte[] ... keys) {
        if (Utils.isEmpty(keys)) {
            return 0L;
        }
        CommandExecutor executor = this.getCommandExecutor();
        boolean unlink = RedisVerUtils.getServerVersion(() -> {
            Map server = (Map)executor.read(null, (Codec)StringCodec.INSTANCE, (RedisCommand)RedisCommands.INFO_SERVER, new Object[0]);
            return server.getOrDefault("redis_version", "");
        }).isSupportUnlink();
        boolean isSwitchDb = this.isSwitchDb();
        return this.batchDeleteOnStandalone(this.options.getDeleteBatchSize(), keys, batchKeys -> {
            RFuture f = null;
            f = isSwitchDb ? executor.evalWriteAsync("", (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)RedisCommands.EVAL_LONG, (unlink ? Constant.Select.UNLINK : Constant.Select.DEL).command(), RedissonConnection.wrapKeys(batchKeys), new Object[]{Utils.intToBytes(this.getDatabase().get())}) : executor.writeAsync((String)null, (Codec)ByteArrayCodec.INSTANCE, (RedisCommand)(unlink ? RedisCommands.UNLINK : RedisCommands.DEL), Arrays.asList(batchKeys).toArray());
            return (Long)executor.get(f);
        });
    }

    @Override
    public List<byte[]> mget(byte[] ... keys) {
        boolean isSwitchDb = this.isSwitchDb();
        CommandExecutor executor = this.getCommandExecutor();
        return this.batchGetOnStandalone(this.options.getFetchBatchSize(), keys, batchKeys -> {
            RFuture f = null;
            f = isSwitchDb ? executor.evalReadAsync("", (Codec)ByteArrayCodec.INSTANCE, RedisCommands.EVAL_LIST, Constant.Select.MGET.command(), RedissonConnection.wrapKeys(batchKeys), new Object[]{Utils.intToBytes(this.getDatabase().get())}) : executor.readAsync("", (Codec)ByteArrayCodec.INSTANCE, RedisCommands.MGET, Arrays.asList(batchKeys).toArray());
            return (List)executor.get(f);
        });
    }

    private static List<Object> wrapKeys(byte[] ... keys) {
        return Collections.unmodifiableList(new ArrayList(Arrays.asList(keys)));
    }

    @Override
    public byte[] del(byte[] key) {
        Object[] objectArray;
        boolean isSwitchDb = this.isSwitchDb();
        RScript script = this.redisson.getScript((Codec)ByteArrayCodec.INSTANCE);
        String string = isSwitchDb ? Constant.Select.GETDEL.command() : "if( redis.call('exists', KEYS[1]) > 0 ) then local value = redis.call('get', KEYS[1]); redis.call('del', KEYS[1]); return value; else local r; return r; end";
        List<byte[]> list = Collections.singletonList(key);
        if (isSwitchDb) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = Utils.intToBytes(this.getDatabase().get());
        } else {
            objectArray = new Object[]{};
        }
        RFuture f = script.evalAsync(RScript.Mode.READ_WRITE, string, RScript.ReturnType.VALUE, list, objectArray);
        return (byte[])this.getCommandExecutor().get(f);
    }

    @Override
    public Set<byte[]> keys(byte[] pattern) {
        boolean isSwitchDb = this.isSwitchDb();
        HashSet<byte[]> keys = new HashSet<byte[]>();
        for (MasterSlaveEntry entry : this.getCommandExecutor().getConnectionManager().getEntrySet()) {
            if (isSwitchDb) {
                keys.addAll(this.scanKeysOnDb(entry, this.getDatabase().get(), pattern, this.options.getScanBatchSize()));
                continue;
            }
            Iterator<byte[]> iterator = this.scanKeys(entry, pattern, this.options.getScanBatchSize());
            while (iterator.hasNext()) {
                keys.add(iterator.next());
            }
        }
        return keys;
    }

    @Override
    public void close() {
    }
}

