/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.cache.redis.connection.spring;

import java.util.Optional;
import org.iherus.shiro.cache.redis.config.RedisConfiguration;
import org.iherus.shiro.cache.redis.connection.BatchOptions;
import org.iherus.shiro.cache.redis.connection.RedisConnection;
import org.iherus.shiro.cache.redis.connection.RedisConnectionFactory;
import org.iherus.shiro.cache.redis.connection.redisson.RedissonClusterConnection;
import org.iherus.shiro.cache.redis.connection.redisson.RedissonConnection;
import org.iherus.shiro.cache.redis.connection.spring.CompatibleRedisConnection;
import org.iherus.shiro.util.Utils;
import org.redisson.api.RedissonClient;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.util.ClassUtils;

public class CompatibleRedisConnectionFactory
implements RedisConnectionFactory {
    private final org.springframework.data.redis.connection.RedisConnectionFactory nativeConnectionFactory;
    private Optional<BatchOptions> batchOptions = Optional.empty();
    private static boolean importRedissonComponent = ClassUtils.isPresent((String)"org.redisson.spring.data.connection.RedissonConnection", null);

    public CompatibleRedisConnectionFactory(org.springframework.data.redis.connection.RedisConnectionFactory connectionFactory) {
        Utils.assertNotNull(connectionFactory, "org.springframework.data.redis.connection.RedisConnectionFactory cannot be null.");
        this.nativeConnectionFactory = connectionFactory;
    }

    public Optional<BatchOptions> getBatchOptions() {
        return this.batchOptions;
    }

    @Override
    public void setBatchOptions(BatchOptions batchOptions) {
        this.batchOptions = Optional.ofNullable(batchOptions);
    }

    public org.springframework.data.redis.connection.RedisConnectionFactory getNativeConnectionFactory() {
        return this.nativeConnectionFactory;
    }

    @Override
    public RedisConnection getConnection() {
        BatchOptions batchOptionsToUse = this.batchOptions.orElse(BatchOptions.defaulted);
        org.springframework.data.redis.connection.RedisConnection connection = this.nativeConnectionFactory.getConnection();
        if (importRedissonComponent) {
            return connection instanceof RedisClusterConnection ? new RedissonClusterConnection((RedissonClient)connection.getNativeConnection(), batchOptionsToUse) : new RedissonConnection((RedissonClient)connection.getNativeConnection(), batchOptionsToUse);
        }
        return new CompatibleRedisConnection(connection, batchOptionsToUse);
    }

    @Override
    public RedisConfiguration getConfiguration() {
        throw new UnsupportedOperationException("This operation is not supported.");
    }
}

