/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.util;

import java.util.function.Supplier;
import org.iherus.shiro.util.Utils;

public abstract class RedisVerUtils {
    private static volatile VersionInfo serverVersion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VersionInfo getServerVersion(Supplier<String> supplier) {
        Utils.assertNotNull(supplier, "Argument[supplier] cannot be null.");
        if (serverVersion != null) return serverVersion;
        Class<RedisVerUtils> clazz = RedisVerUtils.class;
        synchronized (RedisVerUtils.class) {
            if (serverVersion != null) return serverVersion;
            serverVersion = new VersionInfo(supplier.get());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return serverVersion;
        }
    }

    public static final class VersionInfo {
        private final String version;

        VersionInfo(String version) {
            Utils.assertNotBlank(version, "Version must not be blank.");
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean isSupportUnlink() {
            return this.version.startsWith("4");
        }

        public boolean isSupportStream() {
            return this.version.startsWith("5");
        }
    }
}

