/*
 * Decompiled with CFR 0.152.
 */
package org.iherus.shiro.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public abstract class Utils {
    private static final int INITIAL_HASH = 7;
    private static final int MULTIPLIER = 31;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Map<Class<?>, Field[]> LOCAL_FIELDS = new ConcurrentHashMap(256);
    private static final Map<Class<?>, Method[]> LOCAL_METHODS = new ConcurrentHashMap(128);

    public static <T> MutableArray<T> newMutableArray(T ... elements) {
        return new MutableArray<T>(elements);
    }

    public static void assertNotBlank(String text, String message) {
        if (!Utils.isNotBlank(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void assertIsTrue(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalArgumentException(Utils.nullSafeGet(messageSupplier));
        }
    }

    private static String nullSafeGet(Supplier<String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !Utils.isEmpty(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !Utils.isBlank(cs);
    }

    public static String[] split(String toSplit, String delimiter) {
        if (!Utils.hasLength(toSplit) || !Utils.hasLength(delimiter)) {
            return null;
        }
        int offset = toSplit.indexOf(delimiter);
        if (offset < 0) {
            return null;
        }
        String beforeDelimiter = toSplit.substring(0, offset);
        String afterDelimiter = toSplit.substring(offset + delimiter.length());
        return new String[]{beforeDelimiter, afterDelimiter};
    }

    public static Set<String> commaDelimitedListToSet(String str) {
        String[] tokens = Utils.commaDelimitedListToStringArray(str);
        return new LinkedHashSet<String>(Arrays.asList(tokens));
    }

    public static String[] commaDelimitedListToStringArray(String str) {
        return Utils.delimitedListToStringArray(str, ",");
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        return Utils.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if (delimiter.isEmpty()) {
            for (int i = 0; i < str.length(); ++i) {
                result.add(Utils.deleteAny(str.substring(i, i + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(Utils.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(Utils.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return Utils.toStringArray(result);
    }

    public static String[] toStringArray(Collection<String> collection) {
        return !Utils.isEmpty(collection) ? collection.toArray(EMPTY_STRING_ARRAY) : EMPTY_STRING_ARRAY;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (!Utils.hasLength(inString) || !Utils.hasLength(charsToDelete)) {
            return inString;
        }
        StringBuilder sb = new StringBuilder(inString.length());
        for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            if (charsToDelete.indexOf(c) != -1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }

    public static String bytesToText(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] intToBytes(int number) {
        return String.valueOf(number).getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] longToBytes(long number) {
        return String.valueOf(number).getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] clone(byte[] array) {
        if (array == null) {
            return null;
        }
        return (byte[])array.clone();
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(byte[][] array) {
        return array == null || array.length == 0;
    }

    public static byte[] mergeAll(byte[] array1, byte ... array2) {
        if (array1 == null) {
            return Utils.clone(array2);
        }
        if (array2 == null) {
            return Utils.clone(array1);
        }
        byte[] joinedArray = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static byte[] subarray(byte[] array, int startIndexInclusive, int endIndexExclusive) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        if ((newSize = endIndexExclusive - startIndexInclusive) <= 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] subarray = new byte[newSize];
        System.arraycopy(array, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static int nullSafeHashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                return Utils.nullSafeHashCode((Object[])obj);
            }
            if (obj instanceof boolean[]) {
                return Utils.nullSafeHashCode((boolean[])obj);
            }
            if (obj instanceof byte[]) {
                return Utils.nullSafeHashCode((byte[])obj);
            }
            if (obj instanceof char[]) {
                return Utils.nullSafeHashCode((char[])obj);
            }
            if (obj instanceof double[]) {
                return Utils.nullSafeHashCode((double[])obj);
            }
            if (obj instanceof float[]) {
                return Utils.nullSafeHashCode((float[])obj);
            }
            if (obj instanceof int[]) {
                return Utils.nullSafeHashCode((int[])obj);
            }
            if (obj instanceof long[]) {
                return Utils.nullSafeHashCode((long[])obj);
            }
            if (obj instanceof short[]) {
                return Utils.nullSafeHashCode((short[])obj);
            }
        }
        return obj.hashCode();
    }

    public static int nullSafeHashCode(Object[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (Object element : array) {
            hash = 31 * hash + Utils.nullSafeHashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(boolean[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (boolean element : array) {
            hash = 31 * hash + Boolean.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(byte[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (byte element : array) {
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static int nullSafeHashCode(char[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (char element : array) {
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static int nullSafeHashCode(double[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (double element : array) {
            hash = 31 * hash + Double.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(float[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (float element : array) {
            hash = 31 * hash + Float.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(int[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (int element : array) {
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static int nullSafeHashCode(long[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (long element : array) {
            hash = 31 * hash + Long.hashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(short[] array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (short element : array) {
            hash = 31 * hash + element;
        }
        return hash;
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return Utils.arrayEquals(o1, o2);
        }
        return false;
    }

    private static boolean arrayEquals(Object o1, Object o2) {
        if (o1 instanceof Object[] && o2 instanceof Object[]) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        if (o1 instanceof boolean[] && o2 instanceof boolean[]) {
            return Arrays.equals((boolean[])o1, (boolean[])o2);
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof double[] && o2 instanceof double[]) {
            return Arrays.equals((double[])o1, (double[])o2);
        }
        if (o1 instanceof float[] && o2 instanceof float[]) {
            return Arrays.equals((float[])o1, (float[])o2);
        }
        if (o1 instanceof int[] && o2 instanceof int[]) {
            return Arrays.equals((int[])o1, (int[])o2);
        }
        if (o1 instanceof long[] && o2 instanceof long[]) {
            return Arrays.equals((long[])o1, (long[])o2);
        }
        if (o1 instanceof short[] && o2 instanceof short[]) {
            return Arrays.equals((short[])o1, (short[])o2);
        }
        return false;
    }

    public static Field findField(Class<?> clazz, String name) {
        return Utils.findField(clazz, name, null);
    }

    public static <T> T getFieldValue(Object target, String name, Class<T> type) {
        Field field = Utils.findField(target.getClass(), name);
        if (null == field) {
            return null;
        }
        try {
            Utils.makeAccessible(field);
            return type.cast(field.get(target));
        }
        catch (IllegalAccessException ex) {
            Utils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static <T> void setFieldValue(Object target, String name, Class<T> type, Object value) {
        Field field = Utils.findField(target.getClass(), name);
        if (null == field) {
            return;
        }
        try {
            Utils.makeAccessible(field);
            field.set(target, value);
            return;
        }
        catch (IllegalAccessException ex) {
            Utils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        Utils.assertNotNull(clazz, "Class must not be null");
        Utils.assertIsTrue(name != null || type != null, () -> "Either name or type of the field must be specified");
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = Utils.getDeclaredFields(searchType)) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    private static Field[] getDeclaredFields(Class<?> clazz) {
        Utils.assertNotNull(clazz, "Class must not be null");
        Field[] fields = LOCAL_FIELDS.get(clazz);
        if (fields == null) {
            try {
                fields = clazz.getDeclaredFields();
                LOCAL_FIELDS.put(clazz, fields);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
            }
        }
        return fields;
    }

    public static Method findMethod(Class<?> clazz, String name) {
        return Utils.findMethod(clazz, name, new Class[0]);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... argTypes) {
        Utils.assertNotNull(clazz, "Class must not be null");
        Utils.assertNotNull(name, "Method name must not be null");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : Utils.getDeclaredMethods(searchType)) {
                if (!name.equals(method.getName()) || argTypes != null && !Arrays.equals(argTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    private static Method[] getDeclaredMethods(Class<?> clazz) {
        Utils.assertNotNull(clazz, "Class must not be null");
        Method[] methods = LOCAL_METHODS.get(clazz);
        if (null == methods) {
            try {
                Method[] declaredMethods;
                Method[] result = declaredMethods = clazz.getDeclaredMethods();
                List<Method> defaultMethods = Utils.findConcreteMethodsOnInterfaces(clazz);
                if (defaultMethods != null) {
                    result = new Method[declaredMethods.length + defaultMethods.size()];
                    System.arraycopy(declaredMethods, 0, result, 0, declaredMethods.length);
                    int index = declaredMethods.length;
                    Iterator<Method> iterator = defaultMethods.iterator();
                    while (iterator.hasNext()) {
                        Method defaultMethod;
                        result[index] = defaultMethod = iterator.next();
                        ++index;
                    }
                }
                methods = result;
                LOCAL_METHODS.put(clazz, methods);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
            }
        }
        return methods;
    }

    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        ArrayList<Method> result = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result == null) {
                    result = new ArrayList<Method>();
                }
                result.add(ifcMethod);
            }
        }
        return result;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static Object invokeMethod(Object target, String methodName) {
        return Utils.invokeMethod(target, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeSuperMethod(Object target, String methodName) {
        return Utils.invokeSuperMethod(target, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeMethod(Object target, String methodName, Class<?> argType, Object arg) {
        return Utils.invokeMethod(target, methodName, new Class[]{argType}, arg);
    }

    public static Object invokeMethod(Object target, String methodName, Class<?>[] argTypes, Object ... args) {
        Utils.assertNotNull(target, "Object must not be null");
        Method method = Utils.findMethod(target.getClass(), methodName, argTypes);
        if (method == null) {
            return null;
        }
        try {
            Utils.makeAccessible(method);
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            Utils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Object invokeSuperMethod(Object target, String methodName, Class<?>[] argTypes, Object ... args) {
        Utils.assertNotNull(target, "Object must not be null");
        Method method = Utils.findMethod(target.getClass().getSuperclass(), methodName, argTypes);
        if (method == null) {
            return null;
        }
        try {
            Utils.makeAccessible(method);
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            Utils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    private static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method or field: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            Utils.rethrowRuntimeException(((InvocationTargetException)ex).getTargetException());
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    private static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    public static class MutableArray<T> {
        private final ArrayList<T> list;

        MutableArray(T ... initialElements) {
            this.list = new ArrayList<T>(Arrays.asList(initialElements));
        }

        public MutableArray<T> add(boolean executed, Supplier<T> supplier) {
            if (executed) {
                this.list.add(supplier.get());
            }
            return this;
        }

        public MutableArray<T> replace(int index, T e) {
            this.list.set(index, e);
            return this;
        }

        public Object[] toArray() {
            return this.list.toArray();
        }
    }
}

