/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor;

public class ClassUtils {
    private static final ClassLoaderAccessor THREAD_CL_ACCESSOR = new ClassLoaderAccessor(){

        @Override
        protected ClassLoader doGetClassLoader() throws Throwable {
            return Thread.currentThread().getContextClassLoader();
        }
    };
    private static final ClassLoaderAccessor CLASS_CL_ACCESSOR = new ClassLoaderAccessor(){

        @Override
        protected ClassLoader doGetClassLoader() throws Throwable {
            return ClassUtils.class.getClassLoader();
        }
    };
    private static final ClassLoaderAccessor SYSTEM_CL_ACCESSOR = new ClassLoaderAccessor(){

        @Override
        protected ClassLoader doGetClassLoader() throws Throwable {
            return ClassLoader.getSystemClassLoader();
        }
    };

    private ClassUtils() {
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        Class clazz = THREAD_CL_ACCESSOR.loadClass(className);
        if (clazz == null) {
            clazz = CLASS_CL_ACCESSOR.loadClass(className);
        }
        if (clazz == null) {
            clazz = SYSTEM_CL_ACCESSOR.loadClass(className);
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Not found class[" + className + "]");
        }
        return clazz;
    }

    static abstract class ClassLoaderAccessor {
        ClassLoaderAccessor() {
        }

        Class loadClass(String fqcn) {
            Class<?> clazz = null;
            ClassLoader cl = this.getClassLoader();
            if (cl != null) {
                try {
                    clazz = cl.loadClass(fqcn);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return clazz;
        }

        final ClassLoader getClassLoader() {
            try {
                return this.doGetClassLoader();
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        abstract ClassLoader doGetClassLoader() throws Throwable;
    }
}

