/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor;

import com.baidu.ueditor.UeditorConfig;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ConfigManager {
    static final String UEDITOR_CONFIG_PATH = "UEDITOR_CONFIG_PATH";
    private static final ObjectMapper _objectMapper = new ObjectMapper();
    private final String rootPath;
    private final String configPath;
    private static final String configFileName = "ueditor.config.json";
    private Object config = null;
    private static final String SCRAWL_FILE_NAME = "scrawl";
    private static final String REMOTE_FILE_NAME = "remote";

    private ConfigManager(String rootPath, String configPath) throws FileNotFoundException, IOException {
        this.rootPath = rootPath.replace("\\", "/");
        this.configPath = configPath == null ? "" : configPath;
        this.initEnv();
    }

    private ConfigManager(String rootPath, UeditorConfig config) {
        this.rootPath = rootPath;
        this.configPath = null;
        this.config = config;
    }

    public static ConfigManager getInstance(String rootPath, String configPath) {
        try {
            return new ConfigManager(rootPath, configPath);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ConfigManager getInstance(String rootPath, UeditorConfig config) {
        return new ConfigManager(rootPath, config);
    }

    public boolean valid() {
        return this.config != null;
    }

    public Object getAllConfig() {
        return this.config;
    }

    public Map<String, Object> getConfig(int type) {
        if (this.config instanceof JsonNode) {
            return this.getJsonConfig(type);
        }
        return this.getDefaultConfig(type);
    }

    public Map<String, Object> getDefaultConfig(int type) {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        String savePath = null;
        switch (type) {
            case 4: {
                Set<String> fileAllowFiles = ((UeditorConfig)this.config).getFileAllowFiles();
                conf.put("isBase64", "false");
                conf.put("maxSize", ((UeditorConfig)this.config).getFileMaxSize());
                conf.put("allowFiles", fileAllowFiles.toArray(new String[fileAllowFiles.size()]));
                conf.put("fieldName", ((UeditorConfig)this.config).getFileFieldName());
                savePath = ((UeditorConfig)this.config).getFilePathFormat();
                break;
            }
            case 1: {
                Set<String> imageAllowFiles = ((UeditorConfig)this.config).getImageAllowFiles();
                conf.put("isBase64", "false");
                conf.put("maxSize", ((UeditorConfig)this.config).getImageMaxSize());
                conf.put("allowFiles", imageAllowFiles.toArray(new String[imageAllowFiles.size()]));
                conf.put("fieldName", ((UeditorConfig)this.config).getImageFieldName());
                savePath = ((UeditorConfig)this.config).getImagePathFormat();
                break;
            }
            case 3: {
                Set<String> videoAllowFiles = ((UeditorConfig)this.config).getVideoAllowFiles();
                conf.put("maxSize", ((UeditorConfig)this.config).getVideoMaxSize());
                conf.put("allowFiles", videoAllowFiles.toArray(new String[videoAllowFiles.size()]));
                conf.put("fieldName", ((UeditorConfig)this.config).getVideoFieldName());
                savePath = ((UeditorConfig)this.config).getVideoPathFormat();
                break;
            }
            case 2: {
                conf.put("filename", SCRAWL_FILE_NAME);
                conf.put("maxSize", ((UeditorConfig)this.config).getScrawlMaxSize());
                conf.put("fieldName", ((UeditorConfig)this.config).getScrawlFieldName());
                conf.put("isBase64", "true");
                savePath = ((UeditorConfig)this.config).getScrawlPathFormat();
                break;
            }
            case 5: {
                Set<String> catcherAllowFiles = ((UeditorConfig)this.config).getCatcherAllowFiles();
                conf.put("filename", REMOTE_FILE_NAME);
                conf.put("filter", ((UeditorConfig)this.config).getCatcherLocalDomain());
                conf.put("maxSize", ((UeditorConfig)this.config).getCatcherMaxSize());
                conf.put("allowFiles", catcherAllowFiles.toArray(new String[catcherAllowFiles.size()]));
                conf.put("fieldName", ((UeditorConfig)this.config).getCatcherFieldName() + "[]");
                savePath = ((UeditorConfig)this.config).getCatcherPathFormat();
                break;
            }
            case 7: {
                Set<String> imageManagerAllowFiles = ((UeditorConfig)this.config).getImageManagerAllowFiles();
                conf.put("allowFiles", imageManagerAllowFiles.toArray(new String[imageManagerAllowFiles.size()]));
                conf.put("dir", ((UeditorConfig)this.config).getImageManagerListPath());
                conf.put("count", ((UeditorConfig)this.config).getImageManagerListSize());
                break;
            }
            case 6: {
                Set<String> fileManagerAllowFiles = ((UeditorConfig)this.config).getFileManagerAllowFiles();
                conf.put("allowFiles", fileManagerAllowFiles.toArray(new String[fileManagerAllowFiles.size()]));
                conf.put("dir", ((UeditorConfig)this.config).getFileManagerListPath());
                conf.put("count", ((UeditorConfig)this.config).getFileManagerListSize());
            }
        }
        conf.put("savePath", savePath);
        conf.put("rootPath", this.rootPath);
        return conf;
    }

    public Map<String, Object> getJsonConfig(int type) {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        String savePath = null;
        switch (type) {
            case 4: {
                conf.put("isBase64", "false");
                conf.put("maxSize", ((JsonNode)this.config).get("fileMaxSize").asLong());
                conf.put("allowFiles", this.getArray("fileAllowFiles"));
                conf.put("fieldName", ((JsonNode)this.config).get("fileFieldName").asText());
                savePath = ((JsonNode)this.config).get("filePathFormat").asText();
                break;
            }
            case 1: {
                conf.put("isBase64", "false");
                conf.put("maxSize", ((JsonNode)this.config).get("imageMaxSize").asLong());
                conf.put("allowFiles", this.getArray("imageAllowFiles"));
                conf.put("fieldName", ((JsonNode)this.config).get("imageFieldName").asText());
                savePath = ((JsonNode)this.config).get("imagePathFormat").asText();
                break;
            }
            case 3: {
                conf.put("maxSize", ((JsonNode)this.config).get("videoMaxSize").asLong());
                conf.put("allowFiles", this.getArray("videoAllowFiles"));
                conf.put("fieldName", ((JsonNode)this.config).get("videoFieldName").asText());
                savePath = ((JsonNode)this.config).get("videoPathFormat").asText();
                break;
            }
            case 2: {
                conf.put("filename", SCRAWL_FILE_NAME);
                conf.put("maxSize", ((JsonNode)this.config).get("scrawlMaxSize").asLong());
                conf.put("fieldName", ((JsonNode)this.config).get("scrawlFieldName").asText());
                conf.put("isBase64", "true");
                savePath = ((JsonNode)this.config).get("scrawlPathFormat").asText();
                break;
            }
            case 5: {
                conf.put("filename", REMOTE_FILE_NAME);
                conf.put("filter", this.getArray("catcherLocalDomain"));
                conf.put("maxSize", ((JsonNode)this.config).get("catcherMaxSize").asLong());
                conf.put("allowFiles", this.getArray("catcherAllowFiles"));
                conf.put("fieldName", ((JsonNode)this.config).get("catcherFieldName").asText() + "[]");
                savePath = ((JsonNode)this.config).get("catcherPathFormat").asText();
                break;
            }
            case 7: {
                conf.put("allowFiles", this.getArray("imageManagerAllowFiles"));
                conf.put("dir", ((JsonNode)this.config).get("imageManagerListPath").asText());
                conf.put("count", ((JsonNode)this.config).get("imageManagerListSize").asInt());
                break;
            }
            case 6: {
                conf.put("allowFiles", this.getArray("fileManagerAllowFiles"));
                conf.put("dir", ((JsonNode)this.config).get("fileManagerListPath").asText());
                conf.put("count", ((JsonNode)this.config).get("fileManagerListSize").asInt());
            }
        }
        conf.put("savePath", savePath);
        conf.put("rootPath", this.rootPath);
        return conf;
    }

    private void initEnv() throws FileNotFoundException, IOException {
        File file = new File(this.getConfigPath());
        if (!file.isAbsolute()) {
            file = new File(this.getAbsolutePath(file.getPath()));
        }
        String configFilePath = file.isFile() ? file.getPath() : file.getPath() + File.separator + configFileName;
        String configContent = this.readFile(configFilePath);
        try {
            JsonNode jsonConfig = _objectMapper.readTree(configContent);
            this.config = jsonConfig;
        }
        catch (Exception e) {
            this.config = null;
        }
    }

    private String getConfigPath() {
        if (this.configPath == null || "".equals(this.configPath.trim())) {
            return System.getProperty(UEDITOR_CONFIG_PATH);
        }
        return this.configPath;
    }

    private String[] getArray(String key) {
        JsonNode jsonNode = ((JsonNode)this.config).get(key);
        if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            String[] result = new String[jsonNode.size()];
            for (int i = 0; i < arrayNode.size(); ++i) {
                result[i] = arrayNode.get(i).asText();
            }
            return result;
        }
        return new String[0];
    }

    private String readFile(String path) throws IOException {
        StringBuilder builder = new StringBuilder();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8");
            BufferedReader bfReader = new BufferedReader(reader);
            String tmpContent = null;
            while ((tmpContent = bfReader.readLine()) != null) {
                builder.append(tmpContent);
            }
            bfReader.close();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return this.filter(builder.toString());
    }

    private String filter(String input) {
        return input.replaceAll("/\\*[\\s\\S]*?\\*/", "");
    }

    private String getAbsolutePath(String path) throws FileNotFoundException {
        URL resource = this.getClass().getClassLoader().getResource(path == null ? "" : path);
        if (resource == null) {
            throw new FileNotFoundException("Cannot find the target path[" + path + "] under classpath.");
        }
        try {
            return URLDecoder.decode(resource.getPath(), "UTF-8").replace("/\\", "/");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return resource.getPath().replace("%5c", "");
        }
    }
}

