/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.ueditor;

import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;

public class ReflectionUtils {
    private static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    private static final Map<Class<?>, SoftReference<Field[]>> LOCAL_FIELDS = new ConcurrentHashMap(128);
    private static final Map<Class<?>, SoftReference<Method[]>> LOCAL_METHODS = new ConcurrentHashMap(128);

    private ReflectionUtils() {
    }

    public static Field findField(Class<?> clazz, String name) {
        return ReflectionUtils.findField(clazz, name, null);
    }

    public static <T> T getFieldValue(Object target, String name, Class<T> type) {
        Field field = ReflectionUtils.findField(target.getClass(), name);
        if (null == field) {
            return null;
        }
        try {
            ReflectionUtils.makeAccessible(field);
            return type.cast(field.get(target));
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static <T> void setFieldValue(Object target, String name, Class<T> type, Object value) {
        Field field = ReflectionUtils.findField(target.getClass(), name);
        if (null == field) {
            return;
        }
        try {
            ReflectionUtils.makeAccessible(field);
            field.set(target, value);
            return;
        }
        catch (IllegalAccessException ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) {
        ReflectionUtils.assertNotNull(clazz, "Class must not be null");
        ReflectionUtils.assertIsTrue(name != null || type != null, () -> "Either name or type of the field must be specified");
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = ReflectionUtils.getDeclaredFields(searchType)) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        return null;
    }

    private static Field[] getDeclaredFields(Class<?> clazz) {
        ReflectionUtils.assertNotNull(clazz, "Class must not be null");
        SoftReference<Field[]> fieldsRef = LOCAL_FIELDS.get(clazz);
        if (fieldsRef == null) {
            try {
                Field[] declaredFields = clazz.getDeclaredFields();
                fieldsRef = new SoftReference<Field[]>(declaredFields.length == 0 ? EMPTY_FIELD_ARRAY : declaredFields);
                LOCAL_FIELDS.put(clazz, fieldsRef);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
            }
        }
        return fieldsRef.get();
    }

    public static Method findMethod(Class<?> clazz, String name) {
        return ReflectionUtils.findMethod(clazz, name, new Class[0]);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... argTypes) {
        ReflectionUtils.assertNotNull(clazz, "Class must not be null");
        ReflectionUtils.assertNotNull(name, "Method name must not be null");
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : ReflectionUtils.getDeclaredMethods(searchType)) {
                if (!name.equals(method.getName()) || argTypes != null && !Arrays.equals(argTypes, method.getParameterTypes())) continue;
                return method;
            }
        }
        return null;
    }

    private static Method[] getDeclaredMethods(Class<?> clazz) {
        ReflectionUtils.assertNotNull(clazz, "Class must not be null");
        SoftReference<Method[]> methodRef = LOCAL_METHODS.get(clazz);
        if (methodRef == null) {
            try {
                Method[] declaredMethods = clazz.getDeclaredMethods();
                List<Method> defaultMethods = ReflectionUtils.findConcreteMethodsOnInterfaces(clazz);
                Method[] result = declaredMethods;
                if (defaultMethods != null) {
                    result = new Method[declaredMethods.length + defaultMethods.size()];
                    System.arraycopy(declaredMethods, 0, result, 0, declaredMethods.length);
                    int index = declaredMethods.length;
                    Iterator<Method> iterator = defaultMethods.iterator();
                    while (iterator.hasNext()) {
                        Method defaultMethod;
                        result[index] = defaultMethod = iterator.next();
                        ++index;
                    }
                }
                methodRef = new SoftReference<Method[]>(result.length == 0 ? EMPTY_METHOD_ARRAY : result);
                LOCAL_METHODS.put(clazz, methodRef);
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
            }
        }
        return methodRef.get();
    }

    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        ArrayList<Method> result = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result == null) {
                    result = new ArrayList<Method>();
                }
                result.add(ifcMethod);
            }
        }
        return result;
    }

    public static void makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
        }
    }

    public static Object invokeMethod(Object target, String methodName) {
        return ReflectionUtils.invokeMethod(target, methodName, new Class[0], new Object[0]);
    }

    public static Object invokeMethod(Object target, String methodName, Class<?> argType, Object arg) {
        return ReflectionUtils.invokeMethod(target, methodName, new Class[]{argType}, arg);
    }

    public static Object invokeMethod(Object target, String methodName, Class<?>[] argTypes, Object ... args) {
        ReflectionUtils.assertNotNull(target, "Object must not be null");
        Method method = ReflectionUtils.findMethod(target.getClass(), methodName, argTypes);
        if (method == null) {
            return null;
        }
        try {
            ReflectionUtils.makeAccessible(method);
            return method.invoke(target, args);
        }
        catch (Exception ex) {
            ReflectionUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    private static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method or field: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ReflectionUtils.rethrowRuntimeException(((InvocationTargetException)ex).getTargetException());
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    private static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    private static void assertNotNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void assertIsTrue(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalArgumentException(ReflectionUtils.nullSafeGet(messageSupplier));
        }
    }

    private static String nullSafeGet(Supplier<String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }
}

