/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.codegeneration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.ijsberg.iglu.util.codegeneration.JavaMemberSource;
import org.ijsberg.iglu.util.codegeneration.JavaMethodSource;
import org.ijsberg.iglu.util.codegeneration.JavaSource;

public class JavaClassSource
extends JavaSource {
    private String modifiers;
    private String packageName;
    private String className;
    private String implementsClause;
    private String extendsClause;
    private TreeMap imports = new TreeMap();
    private ArrayList members = new ArrayList();
    private ArrayList methods = new ArrayList();
    public static final String RET = "\n";

    public JavaClassSource(String modifiers, String packageName, String className, String implementsClause, String extendsClause) {
        this.modifiers = modifiers;
        this.packageName = packageName;
        this.className = className;
        this.implementsClause = implementsClause;
        this.extendsClause = extendsClause;
    }

    public void addImport(String className) {
        this.imports.put(className, className);
    }

    public void addMember(JavaMemberSource member) {
        this.members.add(member);
    }

    public JavaMethodSource addMethod(JavaMethodSource method) {
        this.methods.add(method);
        return method;
    }

    public JavaMethodSource getMethod(String methodName) {
        for (JavaMethodSource method : this.methods) {
            if (!methodName.equals(method.getMethodName())) continue;
            return method;
        }
        return null;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getName() {
        return (this.packageName != null && !"".equals(this.packageName) ? this.packageName + '.' : "") + this.className;
    }

    public int getNrofMethods() {
        return this.methods.size();
    }

    public String toString() {
        StringBuffer retval = new StringBuffer();
        this.addPackage(retval);
        this.addImports(retval);
        this.addClassDeclaration(retval);
        this.addBody(retval);
        return retval.toString();
    }

    private void addBody(StringBuffer retval) {
        retval.append("{\n");
        Iterator i = this.members.iterator();
        while (i.hasNext()) {
            retval.append(i.next().toString() + RET);
        }
        i = this.methods.iterator();
        while (i.hasNext()) {
            retval.append(RET);
            retval.append(i.next().toString());
        }
        retval.append("}\n");
    }

    private void addClassDeclaration(StringBuffer retval) {
        retval.append(this.modifiers + " class " + this.className);
        if (this.implementsClause != null) {
            retval.append(" implements " + this.implementsClause);
        }
        if (this.extendsClause != null) {
            retval.append(" extends " + this.extendsClause);
        }
        retval.append(RET);
    }

    private void addImports(StringBuffer retval) {
        Iterator i = this.imports.values().iterator();
        while (i.hasNext()) {
            retval.append("import " + i.next() + ';' + RET);
        }
        retval.append(RET);
    }

    private void addPackage(StringBuffer retval) {
        if (this.packageName != null && !"".equals(this.packageName)) {
            retval.append("package " + this.packageName + ';' + RET);
            retval.append(RET);
        }
    }
}

