/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.collection;

import java.util.ArrayList;
import java.util.Collection;

public class CollectionPart {
    private Collection part;
    private int fullCollectionSize;
    private int maxPartSize;
    private int offset;
    private CollectionPartDescription[] collectionPartIds;
    private int currentCollectionPartIdIndex;

    public CollectionPart(Collection full, int maxPartSize, int offset) {
        this.fullCollectionSize = full.size();
        this.maxPartSize = maxPartSize;
        this.offset = offset;
        this.part = new ArrayList();
        if (offset < full.size()) {
            int count = 0;
            for (Object o : full) {
                if (count >= offset && count < offset + maxPartSize) {
                    this.part.add(o);
                }
                ++count;
            }
        }
        this.calculateCollectionPartDescriptions();
    }

    public CollectionPart(Collection part, int maxPartSize, int offset, int fullCollectionSize) {
        this.fullCollectionSize = fullCollectionSize;
        this.maxPartSize = maxPartSize;
        this.offset = offset;
        this.part = part;
        this.calculateCollectionPartDescriptions();
    }

    public Collection getPart() {
        return this.part;
    }

    public int getFullCollectionSize() {
        return this.fullCollectionSize;
    }

    public int getMaxPartSize() {
        return this.maxPartSize;
    }

    public int getPartSize() {
        if (this.part == null) {
            return 0;
        }
        return this.part.size();
    }

    public int getNrofParts() {
        int result = this.fullCollectionSize / this.maxPartSize;
        int rest = this.fullCollectionSize % this.maxPartSize;
        if (rest > 0) {
            return result + 1;
        }
        return result;
    }

    public int getLastPartSize() {
        int rest = this.fullCollectionSize % this.maxPartSize;
        if (rest == 0) {
            return this.maxPartSize;
        }
        return rest;
    }

    public String toString() {
        return this.part.toString();
    }

    public CollectionPartDescription getPreceedingCollectionPartDescription() {
        if (this.currentCollectionPartIdIndex > 0) {
            return this.collectionPartIds[this.currentCollectionPartIdIndex - 1];
        }
        return null;
    }

    public CollectionPartDescription getTrailingCollectionPartDescription() {
        if (this.currentCollectionPartIdIndex < this.collectionPartIds.length - 1) {
            return this.collectionPartIds[this.currentCollectionPartIdIndex + 1];
        }
        return null;
    }

    public CollectionPartDescription getFirstCollectionPartDescription() {
        if (this.collectionPartIds.length > 4 && 0 != this.currentCollectionPartIdIndex && 1 != this.currentCollectionPartIdIndex) {
            return this.collectionPartIds[0];
        }
        return null;
    }

    public CollectionPartDescription getLastCollectionPartDescription() {
        if (this.collectionPartIds.length > 4 && this.collectionPartIds.length - 1 != this.currentCollectionPartIdIndex && this.collectionPartIds.length - 2 != this.currentCollectionPartIdIndex) {
            return this.collectionPartIds[this.collectionPartIds.length - 1];
        }
        return null;
    }

    public CollectionPartDescription[] getNearCollectionPartDescriptions(int scope) {
        if (scope % 2 == 0) {
            ++scope;
        }
        int halfScope = (scope - 1) / 2;
        if (scope >= this.getNrofParts()) {
            return this.collectionPartIds;
        }
        CollectionPartDescription[] result = new CollectionPartDescription[scope];
        if (this.currentCollectionPartIdIndex - halfScope < 0) {
            System.arraycopy(this.collectionPartIds, 0, result, 0, scope);
        } else if (this.currentCollectionPartIdIndex + halfScope > this.collectionPartIds.length - 1) {
            System.arraycopy(this.collectionPartIds, this.collectionPartIds.length - 1 - scope, result, 0, scope);
        } else {
            System.arraycopy(this.collectionPartIds, this.currentCollectionPartIdIndex - halfScope, result, 0, scope);
        }
        return result;
    }

    public CollectionPartDescription[] getAllCollectionPartDescriptions() {
        return this.collectionPartIds;
    }

    private void calculateCollectionPartDescriptions() {
        this.collectionPartIds = new CollectionPartDescription[this.getNrofParts()];
        int displayOffset = 0;
        int count = 0;
        for (count = 0; count < this.getNrofParts() - 1; ++count) {
            displayOffset = count * this.maxPartSize;
            if (displayOffset != this.offset) {
                this.collectionPartIds[count] = new CollectionPartDescription(displayOffset, this.maxPartSize, false);
                continue;
            }
            this.collectionPartIds[count] = new CollectionPartDescription(displayOffset, this.maxPartSize, true);
            this.currentCollectionPartIdIndex = count;
        }
        displayOffset = count * this.maxPartSize;
        if (displayOffset != this.offset) {
            this.collectionPartIds[count] = new CollectionPartDescription(displayOffset, this.getLastPartSize(), false);
        } else {
            this.collectionPartIds[count] = new CollectionPartDescription(displayOffset, this.getLastPartSize(), true);
            this.currentCollectionPartIdIndex = count;
        }
    }

    public static class CollectionPartDescription {
        public int offset;
        public int size;
        public boolean isCurrentCollectionPart;

        public CollectionPartDescription(int offset, int size, boolean isCurrentCollectionPart) {
            this.offset = offset;
            this.size = size;
            this.isCurrentCollectionPart = isCurrentCollectionPart;
        }
    }
}

