/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.ijsberg.iglu.util.io.Receiver;
import org.ijsberg.iglu.util.io.Transceiver;

public class StdIODialog
implements Receiver,
Runnable {
    private PushbackInputStream stdIn;
    private OutputStream stdOut;
    private Transceiver transceiver;
    private boolean closed;

    public StdIODialog(InputStream in, OutputStream out, Transceiver transceiver) {
        this.stdIn = new PushbackInputStream(in);
        this.stdOut = out;
        this.transceiver = transceiver;
    }

    public void openAsync() throws IOException {
        this.transceiver.open(this);
        new Thread(this).start();
    }

    public void open() throws IOException {
        this.transceiver.open(this);
        this.run();
    }

    public void close() {
        if (!this.closed) {
            try {
                this.stdOut.write("close of dialog forced...".getBytes());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.transceiver.close();
        }
    }

    @Override
    public void run() {
        byte[] buffer = new byte[80];
        int count = 0;
        while (!this.closed && count >= 0) {
            try {
                count = this.stdIn.read(buffer);
            }
            catch (IOException ioe) {
                this.close();
            }
            if (count <= 0) continue;
            byte[] message = new byte[count];
            System.arraycopy(buffer, 0, message, 0, count);
            if (!this.closed) {
                this.transceiver.transmit(message);
                continue;
            }
            try {
                this.stdOut.write(("dialog closed: unable to transmit '" + new String(message).trim() + "'...").getBytes());
            }
            catch (IOException ioe) {}
        }
    }

    @Override
    public void onReceive(Object o) {
        try {
            this.stdOut.write((byte[])o);
        }
        catch (IOException ioe) {
            this.close();
        }
    }

    @Override
    public void onTransmissionClose() {
        this.closed = true;
    }
}

