/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.mail;

import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import org.ijsberg.iglu.util.execution.Executable;
import org.ijsberg.iglu.util.io.FileData;
import org.ijsberg.iglu.util.misc.KeyGenerator;

public class EMail {
    private String mailserver = (String)System.getProperties().get("mail.host");
    private String mailfrom;
    private String mailto;
    private String subject;
    private String message;
    private FileData[] attachments;
    private PrintWriter outMail;

    public EMail(String senderName, String senderMailAddress, String mailto, String subject, String message) {
        this(senderName, senderMailAddress, mailto, subject, message, null);
    }

    public EMail(String senderName, String senderMailAddress, String mailto, String subject, String message, FileData[] attachments) {
        String user = (String)System.getProperties().get("user.name");
        if (this.mailserver == null || user == null) {
            throw new RuntimeException("'mail.host' or 'user.name' not set in system properties");
        }
        if (mailto == null || "".equals(mailto)) {
            throw new IllegalArgumentException("recipient unknown");
        }
        this.mailfrom = '\"' + (senderName != null ? senderName : user) + '\"' + " <" + senderMailAddress + '>';
        this.mailto = mailto;
        this.subject = subject != null ? subject.trim() : "";
        this.message = message;
        this.attachments = attachments;
    }

    public Object execute() throws Throwable {
        try {
            URL u = new URL("mailto:" + this.mailto);
            URLConnection c = u.openConnection();
            c.setDoInput(false);
            c.setDoOutput(true);
            c.connect();
            this.outMail = new PrintWriter(c.getOutputStream(), true);
            this.outMail.println("From: " + this.mailfrom);
            this.outMail.println("To: " + this.mailto);
            this.outMail.println("Subject: " + this.subject);
            if (this.attachments == null) {
                this.outMail.println();
                if (this.message != null) {
                    this.outMail.println(this.message);
                }
            } else {
                String boundary = "----=" + KeyGenerator.generateKey();
                this.outMail.println("MIME-Version: 1.0\nContent-Type: multipart/mixed; boundary=\"" + boundary + '\"');
                this.outMail.println();
                if (this.message != null) {
                    this.outMail.println("--" + boundary);
                    this.outMail.println("Content-Type: text/plain;");
                    this.outMail.println("\tcharset=\"iso-8859-1\"");
                    this.outMail.println("Content-Transfer-Encoding: quoted-printable");
                    this.outMail.println();
                    this.outMail.println(this.message);
                }
                for (int i = 0; i < this.attachments.length; ++i) {
                    this.outMail.println();
                    this.outMail.println("--" + boundary);
                    this.outMail.println("Content-Type: " + this.attachments[i].getMimeType() + ';');
                    this.outMail.println("\tname=\"" + this.attachments[i].getFileName() + '\"');
                    this.outMail.println("Content-Transfer-Encoding: base64");
                    this.outMail.println("Content-Disposition: attachment;");
                    this.outMail.println("\tfilename=\"" + this.attachments[i].getFileName() + '\"');
                    this.outMail.println();
                    this.outMail.println(this.attachments[i].getRawDataBase64Encoded());
                    this.outMail.println();
                }
                this.outMail.println("--" + boundary + "--");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("mailing " + this.mailto + " via " + this.mailserver + " failed", t);
        }
        finally {
            if (this.outMail != null) {
                this.outMail.close();
            }
        }
        return null;
    }

    public void abort() {
        if (this.outMail != null) {
            this.outMail.close();
        }
    }

    public void mail() {
        final EMail mail = this;
        Executable exec = new Executable(){

            @Override
            protected Object execute() throws Throwable {
                return mail.execute();
            }
        };
        exec.executeAsync();
    }
}

