/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.misc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public abstract class StringSupport {
    public static String insert(String haystack, String needle, int index) {
        StringBuffer val = new StringBuffer(haystack);
        val.insert(index, needle);
        return val.toString();
    }

    public static String replaceFirst(String haystack, String needle, String newNeedle) {
        StringBuffer val = new StringBuffer(haystack);
        StringSupport.replaceFirst(val, needle, newNeedle);
        return val.toString();
    }

    public static void replaceFirst(StringBuffer haystack, String needle, String newNeedle) {
        int idx = haystack.indexOf(needle);
        if (idx != -1) {
            haystack.replace(idx, idx + needle.length(), newNeedle);
        }
    }

    public static String replaceLast(String haystack, String needle, String newNeedle) {
        StringBuffer val = new StringBuffer(haystack);
        StringSupport.replaceLast(val, needle, newNeedle);
        return val.toString();
    }

    public static void replaceLast(StringBuffer haystack, String needle, String newNeedle) {
        int idx = haystack.lastIndexOf(needle);
        if (idx != -1) {
            haystack.replace(idx, idx + needle.length(), newNeedle);
        }
    }

    public static String replaceAll(String haystack, String needle, String newNeedle) {
        StringBuffer val = new StringBuffer(haystack);
        StringSupport.replaceAll(val, needle, newNeedle);
        return val.toString();
    }

    public static String replaceAll(String haystack, String needle, String newNeedle, int interval) {
        StringBuffer val = new StringBuffer(haystack);
        StringSupport.replaceAll(val, needle, newNeedle, interval);
        return val.toString();
    }

    public static String replaceAll(String haystack, String[] needle, String[] newNeedle) {
        if (needle.length != newNeedle.length) {
            throw new IllegalArgumentException("length of original and replace values do not match (" + needle.length + " != " + newNeedle.length + " )");
        }
        StringBuffer buf = new StringBuffer(haystack);
        for (int i = 0; i < needle.length; ++i) {
            StringSupport.replaceAll(buf, needle[i], newNeedle[i]);
        }
        return buf.toString();
    }

    public static void replaceAll(StringBuffer haystack, String needle, String newNeedle) {
        StringSupport.replaceAll(haystack, needle, newNeedle, 0);
    }

    public static void replaceAll(StringBuffer haystack, String needle, String newNeedle, int interval) {
        if (needle == null || "".equals(needle)) {
            throw new IllegalArgumentException("string to replace may not be empty");
        }
        int idx = haystack.indexOf(needle);
        int nextIdx = -1;
        int processedChunkSize = idx;
        int needleLength = needle.length();
        int newNeedleLength = newNeedle.length();
        while (idx != -1) {
            if (processedChunkSize >= interval) {
                haystack.replace(idx, idx + needleLength, newNeedle);
                nextIdx = haystack.indexOf(needle, idx + newNeedleLength);
                processedChunkSize = nextIdx - idx;
                idx = nextIdx;
                continue;
            }
            nextIdx = haystack.indexOf(needle, idx + newNeedleLength);
            processedChunkSize += nextIdx - idx;
            idx = nextIdx;
            if (newNeedleLength != 0) continue;
            return;
        }
    }

    public static int count(String haystack, String needle) {
        if (needle == null || "".equals(needle)) {
            throw new IllegalArgumentException("string to count not be empty");
        }
        int idx = haystack.indexOf(needle);
        int count = 0;
        while (idx != -1) {
            idx = haystack.indexOf(needle, idx + 1);
            ++count;
        }
        return count;
    }

    public static String condenseWhitespace(String haystack) {
        StringBuffer val = new StringBuffer(haystack);
        StringSupport.condenseWhitespace(val);
        return val.toString();
    }

    public static void condenseWhitespace(StringBuffer haystack) {
        int size = haystack.length();
        boolean prevIsWhiteSpace = false;
        for (int i = 0; i < size; ++i) {
            char c = haystack.charAt(i);
            if (c == '\n' || c == '\r') {
                c = ' ';
                haystack.replace(i, i + 1, " ");
            }
            if (Character.isWhitespace(c)) {
                if (prevIsWhiteSpace) {
                    haystack.delete(i, i + 1);
                    --size;
                    --i;
                }
                prevIsWhiteSpace = true;
                continue;
            }
            prevIsWhiteSpace = false;
        }
    }

    public static String removeAll(String haystack, String needle) {
        return StringSupport.replaceAll(haystack, needle, "");
    }

    public static void removeAll(StringBuffer haystack, String needle) {
        StringSupport.replaceAll(haystack, needle, "");
    }

    public static String esc(String in) {
        if (in == null) {
            return null;
        }
        StringBuffer val = new StringBuffer(in);
        StringSupport.esc(val);
        return val.toString();
    }

    public static void esc(StringBuffer in) {
        if (in == null) {
            return;
        }
        StringSupport.replaceAll(in, "\\", "\\\\");
        StringSupport.replaceAll(in, "'", "\\'");
        StringSupport.replaceAll(in, "\"", "\\\"");
        StringSupport.replaceAll(in, "\n", "\\n");
        StringSupport.replaceAll(in, "\r", "\\r");
    }

    public static boolean isNumeric(String in) {
        char c = '\u0000';
        for (int i = in.length(); i > 0; --i) {
            c = in.charAt(i - 1);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlpha(String in) {
        char c = '\u0000';
        for (int i = in.length(); i > 0; --i) {
            c = in.charAt(i - 1);
            if (Character.isLetter(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumeric(String in) {
        char c = '\u0000';
        for (int i = in.length(); i > 0; --i) {
            c = in.charAt(i - 1);
            if (Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isAlphaNumericOrContainsOnlyCharacters(String in, String chars) {
        char c = '\u0000';
        for (int i = 0; i < in.length(); ++i) {
            c = in.charAt(i);
            if (Character.isLetterOrDigit(c) != (chars.indexOf(c) != -1)) continue;
            return false;
        }
        return true;
    }

    public static boolean containsCharacters(String in, String chars) {
        for (int i = 0; i < chars.length(); ++i) {
            if (in.indexOf(chars.charAt(i)) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean containsOnlyCharacters(String in, String chars) {
        for (int i = 0; i < in.length(); ++i) {
            if (chars.indexOf(in.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static String absorbInputStream(InputStream input) throws IOException {
        return StringSupport.absorbInputStream(input, null);
    }

    public static String absorbInputStream(InputStream input, String encoding) throws IOException {
        char[] buf = new char[1000];
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        br = encoding == null ? new BufferedReader(new InputStreamReader(input)) : new BufferedReader(new InputStreamReader(input, encoding));
        while (br.ready()) {
            int charsRead = br.read(buf);
            sb.append(buf, 0, charsRead);
        }
        return sb.toString();
    }

    public static void writeToOutputStream(String s, OutputStream output) throws IOException {
        StringSupport.writeToOutputStream(s, output, null);
    }

    public static void writeToOutputStream(String s, OutputStream output, String encoding) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new StringReader(s));
        PrintStream writer = encoding != null ? new PrintStream(output, true, encoding) : new PrintStream(output, true);
        while ((line = reader.readLine()) != null) {
            writer.println(line);
        }
    }

    public static List split(String input) {
        return StringSupport.split(input, " ,.:;/\\", false);
    }

    public static List split(String input, String punctuationChars) {
        return StringSupport.split(input, punctuationChars, false);
    }

    public static List split(String input, String punctuationChars, boolean sort) {
        return StringSupport.split(input, punctuationChars, sort, false);
    }

    public static List split(String input, String punctuationChars, String quoteChars) {
        return StringSupport.split(input, punctuationChars, quoteChars, false, false, false);
    }

    public static List split(String input, String punctuationChars, boolean sort, boolean convertToLowerCase) {
        return StringSupport.split(input, punctuationChars, sort, convertToLowerCase, false);
    }

    public static List split(String input, String punctuationChars, boolean sort, boolean convertToLowerCase, boolean distinct) {
        return StringSupport.split(input, punctuationChars, "\"", sort, convertToLowerCase, distinct);
    }

    public static List split(String input, String punctuationChars, String quoteSymbols, boolean sort, boolean convertToLowerCase, boolean distinct) {
        if (input == null) {
            return new ArrayList(0);
        }
        TreeMap<String, Object> storage = new TreeMap<String, Object>();
        ArrayList<String> unsortedStorage = new ArrayList<String>();
        StringBuffer word = new StringBuffer();
        boolean readingWord = false;
        boolean insideQuotes = false;
        char insideQuote = '\u0000';
        for (int i = 0; i < input.length(); ++i) {
            if (readingWord) {
                if (punctuationChars.indexOf(input.charAt(i)) != -1 && !insideQuotes) {
                    String foundWord = word.toString();
                    if (convertToLowerCase) {
                        foundWord = foundWord.toLowerCase();
                    }
                    if (!(sort || distinct && storage.containsKey(foundWord))) {
                        unsortedStorage.add(foundWord);
                    }
                    storage.put(foundWord, new Object());
                    readingWord = false;
                    continue;
                }
                if (quoteSymbols != null && quoteSymbols.indexOf(input.charAt(i)) != -1) {
                    insideQuote = input.charAt(i);
                    insideQuotes = !insideQuotes;
                    continue;
                }
                word.append(input.charAt(i));
                continue;
            }
            if (punctuationChars.indexOf(input.charAt(i)) != -1) continue;
            word = new StringBuffer();
            if (quoteSymbols != null && quoteSymbols.indexOf(input.charAt(i)) != -1) {
                insideQuote = input.charAt(i);
                insideQuotes = !insideQuotes;
            } else {
                word.append(input.charAt(i));
            }
            readingWord = true;
        }
        if (readingWord) {
            String foundWord = word.toString();
            if (convertToLowerCase) {
                foundWord = foundWord.toLowerCase();
            }
            if (!(sort || distinct && storage.containsKey(foundWord))) {
                unsortedStorage.add(foundWord);
            }
            storage.put(foundWord, new Object());
        }
        if (sort) {
            return new ArrayList(storage.keySet());
        }
        return unsortedStorage;
    }

    public static Set extractStringsInbetweenTagsFromText(String input, char startTag, char endTag, boolean sort) {
        TreeMap<String, Object> storage = new TreeMap<String, Object>();
        HashSet<String> unsortedStorage = new HashSet<String>();
        StringBuffer word = new StringBuffer();
        boolean readingWord = false;
        for (int i = 0; i < input.length(); ++i) {
            if (readingWord) {
                if (input.charAt(i) == endTag) {
                    String foundWord = word.toString();
                    if (!sort && !storage.containsKey(foundWord)) {
                        unsortedStorage.add(foundWord);
                    }
                    storage.put(foundWord, new Object());
                    readingWord = false;
                    continue;
                }
                word.append(input.charAt(i));
                continue;
            }
            if (input.charAt(i) != startTag) continue;
            word = new StringBuffer();
            readingWord = true;
        }
        if (readingWord) {
            String foundWord = word.toString();
            if (!sort && !storage.containsKey(foundWord)) {
                unsortedStorage.add(foundWord);
            }
            storage.put(foundWord, new Object());
        }
        if (sort) {
            return storage.keySet();
        }
        return unsortedStorage;
    }

    public static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    public static String getStackTrace(Throwable t, int depth) {
        return StringSupport.getStackTrace(t, depth, null);
    }

    public static String getStackTrace(Throwable t, int depth, String prefix) {
        StringBuffer retval = new StringBuffer();
        int nrWritten = 0;
        retval.append(t.toString());
        StackTraceElement[] elements = t.getStackTrace();
        for (int i = 0; nrWritten < depth && i < elements.length; ++i) {
            String line = elements[i].toString();
            if (prefix != null && !line.startsWith(prefix)) continue;
            retval.append("\n" + line);
            ++nrWritten;
        }
        return retval.toString();
    }

    public static String trim(String input, int maxNrofChars, String end) {
        if (end == null) {
            end = "";
        }
        int margin = end.length();
        if (input != null && input.length() > maxNrofChars + margin) {
            input = input.substring(0, maxNrofChars) + end;
        }
        return input;
    }

    public static char[] createCharArray(int size, char defaultVal) {
        char[] retval = new char[size];
        if (size > 0) {
            if (size < 500) {
                for (int i = 0; i < size; ++i) {
                    retval[i] = defaultVal;
                }
            } else {
                StringSupport.initializelLargeCharArray(retval, defaultVal);
            }
        }
        return retval;
    }

    static char[] initializelLargeCharArray(char[] retval, char defaultVal) {
        int i;
        int size = retval.length;
        retval[0] = defaultVal;
        int half = size / 2 + 1;
        for (i = 1; i < half; i *= 2) {
            System.arraycopy(retval, 0, retval, i, i);
        }
        System.arraycopy(retval, 0, retval, i, size - i);
        return retval;
    }
}

