/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.codegeneration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.ijsberg.iglu.util.codegeneration.JavaMemberSource;

public class JavaMethodSource
extends JavaMemberSource {
    private ArrayList parameters = new ArrayList();
    private ArrayList statements = new ArrayList();
    private TreeMap exceptionTypes = new TreeMap();
    public static final String RET = "\n";

    public JavaMethodSource(String modifiers, String returnType, String name) {
        super(modifiers, returnType, name);
    }

    @Override
    public String toString() {
        StringBuffer retval = new StringBuffer();
        retval.append(this.javaDocToString("\t"));
        retval.append('\t' + this.modifiers + ' ' + this.type + ' ' + this.name);
        this.addParameters(retval);
        this.addThrowsClause(retval);
        retval.append(RET);
        this.addBody(retval);
        return retval.toString();
    }

    private void addBody(StringBuffer retval) {
        retval.append("\t{\n");
        Iterator i = this.statements.iterator();
        while (i.hasNext()) {
            retval.append("\t\t" + i.next() + RET);
        }
        retval.append("\t}\n");
    }

    private void addThrowsClause(StringBuffer retval) {
        if (!this.exceptionTypes.isEmpty()) {
            retval.append(" throws ");
            Iterator i = this.exceptionTypes.values().iterator();
            while (i.hasNext()) {
                retval.append(((Class)i.next()).getName() + (i.hasNext() ? ", " : ""));
            }
        }
    }

    private void addParameters(StringBuffer retval) {
        retval.append('(');
        Iterator i = this.parameters.iterator();
        while (i.hasNext()) {
            retval.append(i.next() + (i.hasNext() ? ", " : ""));
        }
        retval.append(')');
    }

    public void addStatement(String statement) {
        this.statements.add(statement);
    }

    public void addExceptionType(Class exceptionType) {
        this.exceptionTypes.put(exceptionType, exceptionType);
    }

    public String getMethodName() {
        return this.name;
    }
}

