/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.io;

import org.ijsberg.iglu.util.misc.EncodingSupport;
import org.ijsberg.iglu.util.misc.StringSupport;

public class FileData {
    private byte[] rawData;
    private String description = "";
    private String fileName = "";
    private String fileNameNoExt = "";
    private String path = "";
    private String extension = "";
    private String mimeType = "";

    public FileData() {
    }

    public FileData(String fullFileName) {
        this.setFullFileName(fullFileName);
    }

    public FileData(FileData fileData) {
        this.rawData = fileData.rawData;
        this.description = fileData.description;
        this.fileName = fileData.fileName;
        this.fileNameNoExt = fileData.fileNameNoExt;
        this.path = fileData.path;
        this.extension = fileData.extension;
        this.mimeType = fileData.mimeType;
    }

    public FileData(String fullFileName, String mimeType) {
        this.setFullFileName(fullFileName);
        this.mimeType = mimeType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setFullFileName(String fullFileName) {
        fullFileName = StringSupport.replaceAll(fullFileName, "\\", "/");
        int lastFileSeparator = (fullFileName = StringSupport.replaceAll(fullFileName, "//", "/")).lastIndexOf(47);
        this.path = lastFileSeparator != -1 ? fullFileName.substring(0, lastFileSeparator) : "";
        this.setFileName(fullFileName.substring(lastFileSeparator + 1, fullFileName.length()));
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public String getRawDataBase64Encoded() {
        return EncodingSupport.encodeBase64(this.rawData, 57);
    }

    public void setRawData(byte[] data) {
        this.rawData = data;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        if (fileName.lastIndexOf(46) != -1) {
            this.extension = fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length());
            this.fileNameNoExt = fileName.substring(0, fileName.lastIndexOf(46));
        } else {
            this.extension = "";
            this.fileNameNoExt = fileName;
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getPath() {
        return this.path;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileNameWithoutExtension() {
        return this.fileNameNoExt;
    }

    public String getFullFileName() {
        return (!"".equals(this.path) ? this.path + '/' : "") + this.fileName;
    }

    public int getSize() {
        if (this.rawData != null) {
            return this.rawData.length;
        }
        return 0;
    }

    public String toString() {
        return "file " + this.fileName + " (" + this.mimeType + ") size=" + this.getSize() + " bytes (" + this.description + ')';
    }
}

