/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.ijsberg.iglu.util.collection.CollectionSupport;
import org.ijsberg.iglu.util.formatting.PatternMatchingSupport;
import org.ijsberg.iglu.util.io.StreamSupport;
import org.ijsberg.iglu.util.misc.StringSupport;

public abstract class FileSupport {
    private static final int COPY_BUFFER = 100000;

    public static ArrayList<File> getFilesInDirectoryTree(String path) {
        File directory = new File(path);
        return FileSupport.getContentsInDirectoryTree(directory, null, true, false);
    }

    public static ArrayList<File> getFilesInDirectoryTree(File directory) {
        return FileSupport.getContentsInDirectoryTree(directory, null, true, false);
    }

    public static ArrayList<File> getFilesInDirectoryTree(String path, String mask) {
        File file = new File(path);
        return FileSupport.getContentsInDirectoryTree(file, mask, true, false);
    }

    public static ArrayList<File> getFilesInDirectoryTree(File file, String mask) {
        return FileSupport.getContentsInDirectoryTree(file, mask, true, false);
    }

    private static ArrayList<File> getContentsInDirectoryTree(File directory, String mask, boolean returnFiles, boolean returnDirs) {
        File[] files;
        ArrayList<File> result = new ArrayList<File>();
        if (directory != null && !directory.isFile() && (files = directory.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    if (returnDirs && (mask == null || PatternMatchingSupport.valueMatchesWildcardExpression(files[i].getName(), mask))) {
                        result.add(files[i]);
                    }
                    result.addAll(FileSupport.getContentsInDirectoryTree(files[i], mask, returnFiles, returnDirs));
                    continue;
                }
                if (!returnFiles || mask != null && !PatternMatchingSupport.valueMatchesWildcardExpression(files[i].getName(), mask)) continue;
                result.add(files[i]);
            }
        }
        return result;
    }

    public static ArrayList<File> getDirectoriesInDirectoryTree(String path) {
        File file = new File(path);
        return FileSupport.getContentsInDirectoryTree(file, null, false, true);
    }

    public static ArrayList<File> getDirectoriesInDirectoryTree(String path, String mask) {
        File file = new File(path);
        return FileSupport.getContentsInDirectoryTree(file, mask, false, true);
    }

    public static ArrayList<File> getFilesInDirectoryTree(String path, String mask, boolean returnDirs) {
        File file = new File(path);
        return FileSupport.getContentsInDirectoryTree(file, mask, true, returnDirs);
    }

    public static File getClassFileFromDirectoryInClassPath(String className) {
        String fileName = StringSupport.replaceAll(className, ".", "/");
        fileName = fileName + ".class";
        return FileSupport.getFileFromDirectoryInClassPath(fileName, System.getProperty("java.class.path"));
    }

    public static File getFileFromDirectoryInClassPath(String fileName, String classPath) {
        List<String> paths = StringSupport.split(classPath, ";:", false);
        for (String singlePath : paths) {
            File file;
            File dir = new File(singlePath);
            if (!dir.isDirectory() || !(file = new File(singlePath + '/' + fileName)).exists()) continue;
            return file;
        }
        return null;
    }

    public static byte[] getBinaryFromFS(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.exists()) {
            return FileSupport.getBinaryFromFS(file);
        }
        throw new FileNotFoundException("file '" + fileName + "' does not exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBinaryFromFS(File existingFile) throws IOException {
        FileInputStream in = new FileInputStream(existingFile);
        try {
            byte[] byArray = StreamSupport.absorbInputStream(in);
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static ZipEntry getClassZipEntryFromJarInClassPath(String className) throws IOException {
        String fileName = StringSupport.replaceAll(className, ".", "/");
        fileName = fileName + ".class";
        List<String> jars = StringSupport.split(System.getProperty("java.class.path"), ";:", false);
        for (String jarFileName : jars) {
            ZipEntry entry;
            if (!jarFileName.endsWith(".jar") && !jarFileName.endsWith(".zip") || (entry = FileSupport.getZipEntryFromJar(fileName, jarFileName)) == null) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBinaryFromJar(String fileName, String jarFileName) throws IOException {
        ZipFile zipfile = new ZipFile(jarFileName);
        try {
            byte[] byArray;
            ZipEntry entry = zipfile.getEntry(fileName);
            if (entry == null) {
                throw new IOException("entry " + fileName + " not found in jar " + jarFileName);
            }
            InputStream in = zipfile.getInputStream(entry);
            try {
                byArray = StreamSupport.absorbInputStream(in);
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
            in.close();
            return byArray;
        }
        finally {
            zipfile.close();
        }
    }

    public static byte[] getBinaryFromClassPath(String fileName, String classPath) throws IOException {
        byte[] retval = null;
        List<String> paths = StringSupport.split(classPath, ";:", false);
        for (String path : paths) {
            File dir;
            retval = path.endsWith(".zip") || path.endsWith(".jar") ? FileSupport.getBinaryFromJar(fileName, path) : FileSupport.getBinaryFromFS(path + '/' + fileName);
            if (retval == null && (dir = new File(path)).exists() && dir.isDirectory()) {
                ArrayList<File> jars = FileSupport.getFilesInDirectoryTree(dir, "*.jar");
                for (File jar : jars) {
                    try {
                        retval = FileSupport.getBinaryFromJar(fileName, jar.getPath());
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (retval == null) continue;
                    return retval;
                }
            }
            if (retval == null) continue;
            return retval;
        }
        return null;
    }

    public static byte[] getBinaryFromClassLoader(String path) throws IOException {
        return StreamSupport.absorbInputStream(FileSupport.getInputStreamFromClassLoader(path));
    }

    public static InputStream getInputStreamFromClassLoader(String path) throws IOException {
        ClassLoader classLoader = FileSupport.class.getClassLoader();
        InputStream retval = classLoader.getResourceAsStream(path);
        if (retval == null) {
            throw new IOException("class loader can not load resource '" + path + "'");
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyClassLoadableResourceToFileSystem(String pathToResource, String outputPath) throws IOException {
        InputStream input = FileSupport.getInputStreamFromClassLoader(pathToResource);
        File outputFile = new File(outputPath);
        if (outputFile.isDirectory()) {
            outputFile = new File(outputFile.getPath() + '/' + FileSupport.getFileNameFromPath(pathToResource));
        }
        FileOutputStream output = new FileOutputStream(outputFile);
        try {
            StreamSupport.absorbInputStream(input, output);
        }
        finally {
            ((OutputStream)output).close();
            input.close();
        }
    }

    public static ZipEntry getZipEntryFromJar(String fileName, String jarFileName) throws IOException {
        ZipFile zipfile = new ZipFile(jarFileName);
        return zipfile.getEntry(fileName);
    }

    public static File createFile(String filename) throws IOException {
        File file = new File(filename);
        if (!file.exists()) {
            File path = new File(file.getParent());
            path.mkdirs();
            file.createNewFile();
        }
        return file;
    }

    public static void emptyDirectory(String path) {
        FileSupport.deleteContentsInDirectoryTree(path, null);
    }

    public static void emptyDirectory(File file) {
        FileSupport.deleteContentsInDirectoryTree(file, null);
    }

    public static void deleteFile(File file) {
        FileSupport.deleteContentsInDirectoryTree(file, null);
        file.delete();
    }

    public static void copyFile(String fileName, String newFileName, boolean overwriteExisting) throws IOException {
        File file = new File(fileName);
        if (!file.exists()) {
            throw new IOException("file '" + fileName + "' does not exist");
        }
        if (file.isDirectory()) {
            throw new IOException('\'' + fileName + "' is a directory");
        }
        File newFile = new File(newFileName);
        if (file.isDirectory()) {
            newFile = new File(file.getPath() + '/' + FileSupport.getFileNameFromPath(fileName));
        }
        if (!overwriteExisting && newFile.exists()) {
            throw new IOException("file '" + newFileName + "' already exists");
        }
        byte[] buffer = new byte[100000];
        int read = 0;
        FileInputStream in = new FileInputStream(file);
        FileOutputStream out = new FileOutputStream(newFile);
        while ((read = in.read(buffer)) > 0) {
            out.write(buffer, 0, read);
        }
        out.close();
        in.close();
    }

    public static void deleteContentsInDirectoryTree(String path, String mask) {
        FileSupport.deleteContentsInDirectoryTree(new File(path), mask);
    }

    public static void deleteContentsInDirectoryTree(File root, String mask) {
        ArrayList<File> files = FileSupport.getContentsInDirectoryTree(root, mask, true, true);
        for (File file : files) {
            if (!file.exists()) continue;
            if (file.isDirectory()) {
                FileSupport.emptyDirectory(file.getAbsolutePath());
            }
            file.delete();
        }
    }

    public static Map<Integer, Integer> countOccurencesInTextFile(File file, String searchString) throws IOException {
        TreeMap<Integer, Integer> retval = new TreeMap<Integer, Integer>();
        FileInputStream input = new FileInputStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        String line = reader.readLine();
        int lineCount = 1;
        while (line != null) {
            int occCount = -1;
            while ((occCount = line.indexOf(searchString, occCount + 1)) != -1) {
                Integer lineNo = new Integer(lineCount);
                Integer nrofOccurrencesInLine = retval.get(lineNo);
                nrofOccurrencesInLine = nrofOccurrencesInLine == null ? new Integer(1) : new Integer(nrofOccurrencesInLine + 1);
                retval.put(lineNo, nrofOccurrencesInLine);
            }
            ++lineCount;
            line = reader.readLine();
        }
        return retval;
    }

    private static void printUsage() {
        System.out.println("Commandline use of FileSupport only supports recursive investigation of directories");
        System.out.println("Usage: java FileSupport -{d(elete)|s(how)} <path> [<mask>] [-f(ind) <word>]");
    }

    public static void main(String[] args) {
        if (args.length >= 2) {
            if (args[0].startsWith("-d")) {
                if (args.length == 3) {
                    FileSupport.deleteContentsInDirectoryTree(args[1], args[2]);
                    return;
                }
                if (args.length == 2) {
                    FileSupport.emptyDirectory(args[1]);
                    return;
                }
            }
            if (args[0].startsWith("-s")) {
                if (args.length == 2) {
                    CollectionSupport.print(FileSupport.getFilesInDirectoryTree(args[1], null, true));
                    return;
                }
                if (args.length == 3) {
                    CollectionSupport.print(FileSupport.getFilesInDirectoryTree(args[1], args[2], true));
                    return;
                }
                if (args.length > 3) {
                    if (args.length == 4 && args[2].startsWith("-f")) {
                        ArrayList<File> files = FileSupport.getFilesInDirectoryTree(args[1]);
                        FileSupport.printOccurringString(files, args[3]);
                        return;
                    }
                    if (args.length == 5 && args[3].startsWith("-f")) {
                        ArrayList<File> files = FileSupport.getFilesInDirectoryTree(args[1], args[2]);
                        FileSupport.printOccurringString(files, args[4]);
                        return;
                    }
                }
            }
        }
        FileSupport.printUsage();
    }

    private static void printOccurringString(List files, String searchString) {
        for (File file : files) {
            try {
                Map<Integer, Integer> occurrences = FileSupport.countOccurencesInTextFile(file, searchString);
                if (occurrences.size() <= 0) continue;
                int total = 0;
                StringBuffer message = new StringBuffer();
                for (Integer lineNo : occurrences.keySet()) {
                    Integer no = occurrences.get(lineNo);
                    total += no.intValue();
                    message.append("line " + lineNo + ": " + no + "\n");
                }
                System.out.println(total + " occurrence" + (total > 1 ? "s" : "") + " found in file '" + file.getAbsolutePath() + "'\n" + message);
            }
            catch (IOException e) {
                System.out.println("error while trying to read file " + file.getAbsolutePath() + " with message: " + e.getMessage());
            }
        }
    }

    public static String convertToUnixStylePath(String path) {
        String retval = StringSupport.replaceAll(path, "\\", "/");
        retval = StringSupport.replaceAll(retval, "//", "/");
        return retval;
    }

    public static String getFileNameFromPath(String path) {
        String unixStylePath = FileSupport.convertToUnixStylePath(path);
        if (unixStylePath.endsWith("/")) {
            throw new IllegalArgumentException("path '" + path + "' points to a directory");
        }
        return unixStylePath.substring(unixStylePath.lastIndexOf(47) + 1);
    }

    public static File createTmpDir() throws IOException {
        File file = File.createTempFile("iglu_util_test_", null);
        file.delete();
        file.mkdirs();
        return file;
    }

    public static File createTmpDir(String prefix) throws IOException {
        File file = File.createTempFile(prefix, null);
        file.delete();
        file.mkdirs();
        return file;
    }
}

