/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.ijsberg.iglu.util.io.Receiver;
import org.ijsberg.iglu.util.io.Transmitter;

public class Forwarder
implements Receiver {
    private OutputStream outputStream;
    private Transmitter outputTransmitter;

    public Forwarder(Transmitter outputTransmitter) {
        this.outputTransmitter = outputTransmitter;
    }

    public Forwarder(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void onReceive(Object message) {
        if (this.outputTransmitter != null) {
            this.outputTransmitter.transmit(message);
        } else {
            try {
                if (message instanceof byte[]) {
                    this.outputStream.write((byte[])message);
                } else {
                    this.outputStream.write(message.toString().getBytes());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onTransmissionClose() {
        try {
            this.outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void close() {
        try {
            this.outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

