/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.time;

import java.util.Date;
import java.util.GregorianCalendar;

public abstract class TimeSupport {
    public static final long defaultGMTOffsetInMillis = TimeSupport.getStandardGMTOffset();

    private static long getStandardGMTOffset() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        return cal.get(16) + cal.get(15);
    }

    public static boolean isToday(Date date) {
        GregorianCalendar calInput = new GregorianCalendar();
        calInput.setTime(date);
        GregorianCalendar calToday = new GregorianCalendar();
        calToday.setTime(new Date());
        return calInput.get(6) == calToday.get(6) && calInput.get(1) == calToday.get(1);
    }

    public static boolean isBeforeToday(Date date) {
        GregorianCalendar calInput = new GregorianCalendar();
        calInput.setTime(date);
        GregorianCalendar calToday = new GregorianCalendar();
        calToday.setTime(new Date());
        return calInput.get(1) * 1000 + calInput.get(6) < calToday.get(1) * 1000 + calToday.get(6);
    }

    public static boolean isAfterToday(Date date) {
        GregorianCalendar calInput = new GregorianCalendar();
        calInput.setTime(date);
        GregorianCalendar calToday = new GregorianCalendar();
        calToday.setTime(new Date());
        return calInput.get(1) * 1000 + calInput.get(6) > calToday.get(1) * 1000 + calToday.get(6);
    }

    public static int getMinutesSinceMidnight(long gmtOffset) {
        return TimeSupport.getMinutesSinceMidnight(System.currentTimeMillis(), gmtOffset);
    }

    public static int getMinutesSinceMidnight(long timeInMillis, long gmtOffset) {
        if (gmtOffset > 86400000L || gmtOffset < -86400000L) {
            throw new IllegalArgumentException("time can not differ more than a day from GMT");
        }
        return (int)((timeInMillis += gmtOffset) - 86400000L * ((timeInMillis + 30000L) / 86400000L)) / 60000;
    }

    public static int getIntervalsSinceMidnight(int intervalInMinutes, long timeInMillis, long gmtOffset) {
        if (gmtOffset > 86400000L || gmtOffset < -86400000L) {
            throw new IllegalArgumentException("time can not differ more than a day from GMT");
        }
        if (intervalInMinutes <= 0) {
            throw new IllegalArgumentException("intervalInMinutes must be larger than 0");
        }
        return (int)((timeInMillis += gmtOffset) - 86400000L * ((timeInMillis + 30000L) / 86400000L)) / (60000 * intervalInMinutes);
    }

    public static boolean isSameInterval(int intervalInMinutes, long time1, long time2, long gmtOffset) {
        if (gmtOffset > 86400000L || gmtOffset < -86400000L) {
            throw new IllegalArgumentException("time can not differ more than a day from GMT");
        }
        if (intervalInMinutes <= 0) {
            throw new IllegalArgumentException("intervalInMinutes must be larger than 0");
        }
        return TimeSupport.floorToIntervalStart(intervalInMinutes, time1, gmtOffset) == TimeSupport.floorToIntervalStart(intervalInMinutes, time2, gmtOffset);
    }

    public static boolean isSameDay(long time1, long time2) {
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTime(new Date(time1));
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(new Date(time2));
        return cal1.get(1) == cal2.get(1) && cal1.get(6) == cal2.get(6);
    }

    public static boolean isSameWeek(long time1, long time2) {
        GregorianCalendar cal1 = new GregorianCalendar();
        cal1.setTime(new Date(time1));
        GregorianCalendar cal2 = new GregorianCalendar();
        cal2.setTime(new Date(time2));
        return cal1.get(3) == cal2.get(3);
    }

    public static long floorToIntervalStart(int intervalInMinutes, long time, long gmtOffset) {
        return (long)(60000 * intervalInMinutes) * ((time + gmtOffset) / (long)(60000 * intervalInMinutes));
    }

    public static long roundToMinute(long time) {
        return 60000L * ((time + 30000L) / 60000L);
    }

    public static boolean isIntervalStart(int intervalInMinutes, int offsetInMinutes, long gmtOffset) {
        if (gmtOffset > 86400000L || gmtOffset < -86400000L) {
            throw new IllegalArgumentException("time can not differ more than a day from GMT");
        }
        if (intervalInMinutes <= 0) {
            throw new IllegalArgumentException("interval must be larger than 0");
        }
        while (offsetInMinutes < 0) {
            offsetInMinutes = intervalInMinutes + offsetInMinutes;
        }
        while (offsetInMinutes > intervalInMinutes) {
            offsetInMinutes -= intervalInMinutes;
        }
        long interval = 60000 * intervalInMinutes;
        long currentTime = System.currentTimeMillis() + gmtOffset;
        return interval * ((currentTime + 30000L) / interval) + (long)(offsetInMinutes * 60000) == TimeSupport.roundToMinute(currentTime);
    }

    public static boolean isIntervalStart(int intervalInMinutes, long gmtOffset) {
        if (gmtOffset > 86400000L || gmtOffset < -86400000L) {
            throw new IllegalArgumentException("time can not differ more than a day from GMT");
        }
        if (intervalInMinutes <= 0) {
            throw new IllegalArgumentException("interval must be larger than 0");
        }
        long interval = 60000 * intervalInMinutes;
        long currentTime = System.currentTimeMillis() + gmtOffset;
        return interval * ((currentTime + 30000L) / interval) == TimeSupport.roundToMinute(currentTime);
    }

    public static long determineMillisUntilNextInterval(int intervalInMinutes, long gmtOffset) {
        if (gmtOffset > 86400000L || gmtOffset < -86400000L) {
            throw new IllegalArgumentException("time can not differ more than a day from GMT");
        }
        if (intervalInMinutes <= 0) {
            throw new IllegalArgumentException("interval must be larger than 0");
        }
        long currentTime = System.currentTimeMillis() + gmtOffset;
        long interval = 60000L * (long)intervalInMinutes;
        long result = interval - (currentTime - interval * (currentTime / interval));
        return result;
    }
}

