/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.collection;

import java.io.PrintStream;
import java.util.Arrays;

public abstract class ArraySupport {
    public static int determineIndexInRange(Object value, Object[] range, int defaultIndex) {
        if (value == null) {
            return defaultIndex;
        }
        int result = defaultIndex;
        for (int i = 0; i < range.length; ++i) {
            if (!value.equals(range[i])) continue;
            result = i;
            break;
        }
        return result;
    }

    public static void print(Object[] array) {
        ArraySupport.print(array, System.out);
    }

    public static void print(Object[] array, PrintStream out) {
        ArraySupport.print(array, System.out, System.getProperty("line.separator"));
    }

    public static void print(Object[] array, PrintStream out, String separator) {
        out.print(ArraySupport.format(array, separator));
    }

    public static String format(Object[] array, String separator) {
        return ArraySupport.format(null, array, separator);
    }

    public static String format(String itemPrefix, Object[] array, String separator) {
        if (array == null) {
            return "";
        }
        StringBuffer retval = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            retval.append((itemPrefix != null ? itemPrefix : "") + array[i] + (i + 1 != array.length ? separator : ""));
        }
        return retval.toString();
    }

    public static String format(String itemPrefix, String itemPostfix, Object[] array, String separator) {
        if (array == null) {
            return "";
        }
        StringBuffer retval = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            retval.append((itemPrefix != null ? itemPrefix : "") + array[i] + (itemPostfix != null ? itemPostfix : "") + (i + 1 != array.length ? separator : ""));
        }
        return retval.toString();
    }

    public static String format(int[] array, String separator) {
        if (array == null) {
            return null;
        }
        StringBuffer retval = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            retval.append(array[i] + (i + 1 != array.length ? separator : ""));
        }
        return retval.toString();
    }

    public static String format(byte[] array, String separator) {
        if (array == null) {
            return null;
        }
        StringBuffer retval = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            retval.append(array[i] + (i + 1 != array.length ? separator : ""));
        }
        return retval.toString();
    }

    public static <T> T[] getFilledArray(T[] array, T val) {
        Arrays.fill(array, val);
        return array;
    }
}

