/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.collection;

import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.ijsberg.iglu.util.collection.ArraySupport;

public abstract class CollectionSupport {
    public static final String LINE_SEP = System.getProperty("line.separator");

    public static void print(Collection coll) {
        CollectionSupport.print(coll, System.out);
    }

    public static void print(Collection coll, PrintStream out) {
        CollectionSupport.print(coll, out, LINE_SEP);
    }

    public static void print(Collection coll, PrintStream out, String separator) {
        out.print(CollectionSupport.format(coll, separator));
    }

    public static String format(Collection<?> coll, String separator) {
        return CollectionSupport.format(null, coll, separator);
    }

    public static String format(String itemPrefix, Collection coll, String separator) {
        if (coll == null) {
            return "";
        }
        return ArraySupport.format(itemPrefix, coll.toArray(), separator);
    }

    public static String format(String itemPrefix, String itemPostfix, Collection coll, String separator) {
        if (coll == null) {
            return "";
        }
        return ArraySupport.format(itemPrefix, itemPostfix, coll.toArray(), separator);
    }

    public static void print(Map map) {
        CollectionSupport.print(map, System.out);
    }

    public static void print(Map map, PrintStream out) {
        CollectionSupport.print(map, System.out, System.getProperty("line.separator"));
    }

    public static void print(Map map, PrintStream out, String separator) {
        out.println(CollectionSupport.format(map, separator));
    }

    public static String format(Map map, String separator) {
        StringBuffer retval = new StringBuffer();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            Object key = i.next();
            retval.append(key + "=" + map.get(key) + (i.hasNext() ? separator : ""));
        }
        return retval.toString();
    }
}

