/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class ListMap<K, V> {
    protected TreeMap<K, List<V>> internalMap = new TreeMap();
    private int loadFactor = 10;

    public ListMap() {
    }

    public ListMap(int loadFactor) {
        this.loadFactor = loadFactor;
    }

    protected List<V> createOrRetrieveList(K key) {
        List<V> list = this.internalMap.get(key);
        if (list == null) {
            list = new ArrayList<V>(this.loadFactor);
            this.internalMap.put(key, list);
        }
        return list;
    }

    public List<V> put(K key, V value) {
        List<V> list = this.createOrRetrieveList(key);
        list.add(value);
        return list;
    }

    public TreeMap<K, List<V>> getMap() {
        return this.internalMap;
    }

    public List<V> get(K key) {
        return this.internalMap.get(key);
    }

    public List<V> getByIndex(int index) {
        return this.internalMap.get(new ArrayList<K>(this.internalMap.keySet()).get(index));
    }

    public String toString() {
        return this.internalMap.toString();
    }

    public Set<K> keySet() {
        return this.internalMap.keySet();
    }

    public Set<K> descendingKeySet() {
        return this.internalMap.descendingKeySet();
    }

    public int size() {
        int retval = 0;
        for (List<V> list : this.internalMap.values()) {
            retval += list.size();
        }
        return retval;
    }

    public Collection<V> values() {
        ArrayList<V> retval = new ArrayList<V>();
        for (List<V> list : this.internalMap.values()) {
            retval.addAll(list);
        }
        return retval;
    }

    public List<V> getTop(int x) {
        ArrayList retval = new ArrayList();
        for (List values : this.internalMap.descendingMap().values()) {
            if (retval.size() == x) {
                return retval;
            }
            if (values.size() < x - retval.size()) {
                retval.addAll(values);
                continue;
            }
            retval.addAll(values.subList(0, x - retval.size()));
        }
        return retval;
    }

    public void removeFirst(K key) {
        List<V> list = this.internalMap.get(key);
        if (!list.isEmpty()) {
            list.remove(0);
        }
    }
}

