/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.execution;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.ijsberg.iglu.util.collection.ArraySupport;
import org.ijsberg.iglu.util.io.FileSupport;
import org.ijsberg.iglu.util.io.Filter;
import org.ijsberg.iglu.util.io.Forwarder;
import org.ijsberg.iglu.util.io.Pipe;
import org.ijsberg.iglu.util.io.Receiver;
import org.ijsberg.iglu.util.io.StdIODialog;
import org.ijsberg.iglu.util.io.Transceiver;
import org.ijsberg.iglu.util.io.Transmitter;
import org.ijsberg.iglu.util.io.Transponder;
import org.ijsberg.iglu.util.misc.StringSupport;

public class CommandShell
implements Transceiver {
    private Process proc;
    private Receiver receiver;
    private Transponder errorForwarder;
    private Transponder outputForwarder;
    private String[] commandArray;
    private File workingDir;
    private boolean isClosed;
    private StringBuffer command = new StringBuffer();

    public CommandShell(String[] shellCommandArray, String[] alternativeEnvVars, File workingDir) {
        this.commandArray = shellCommandArray;
        String[] envVars = alternativeEnvVars;
        this.workingDir = workingDir;
    }

    public CommandShell(String shellCommand, String[] alternativeEnvVars, File workingDir) {
        this(new String[]{shellCommand}, alternativeEnvVars, workingDir);
    }

    public CommandShell(String shellCommand, File workingDir) {
        this(new String[]{shellCommand}, null, workingDir);
    }

    public CommandShell(String[] shellCommandArray, File workingDir) {
        this(shellCommandArray, null, workingDir);
    }

    @Override
    public void transmit(Object message) {
        try {
            boolean commandFlushed = false;
            byte[] b = (byte[])message;
            for (int i = 0; i < b.length; ++i) {
                byte b2 = b[i];
                if (!(b2 != 10 && b2 != 13 || commandFlushed)) {
                    commandFlushed = true;
                    if ("exit".equals(this.command.toString().trim())) {
                        this.close();
                        continue;
                    }
                    this.command.append('\n');
                    this.proc.getOutputStream().write(this.command.toString().getBytes());
                    this.proc.getOutputStream().flush();
                    this.command = new StringBuffer();
                    continue;
                }
                this.command = this.command.append((char)b2);
            }
        }
        catch (IOException e) {
            this.close();
        }
    }

    @Override
    public void close() {
        if (this.receiver != null) {
            this.receiver.onTransmissionClose();
        }
        if (this.proc != null) {
            this.proc.destroy();
            this.errorForwarder.stop();
            this.outputForwarder.stop();
        }
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    public static int available() {
        return 0;
    }

    public static Object read() {
        return null;
    }

    @Override
    public Receiver open(Receiver receiver) {
        this.receiver = receiver;
        Runtime rt = Runtime.getRuntime();
        try {
            this.proc = rt.exec(this.commandArray, null, this.workingDir);
        }
        catch (IOException e) {
            throw new RuntimeException("can not start command shell [" + ArraySupport.format(this.commandArray, ",") + "] + in directory " + this.workingDir);
        }
        this.errorForwarder = new Transponder(this.proc.getErrorStream(), (Transmitter)new Pipe(receiver, new NewLineFilter()));
        this.outputForwarder = new Transponder(this.proc.getInputStream(), (Transmitter)new Pipe(receiver, new NewLineFilter()));
        this.errorForwarder.start();
        this.outputForwarder.start();
        return receiver;
    }

    public static int execute(String[] commandArray, String[] alternativeEnvVars, File workingDir, Receiver outputReceiver) throws IOException {
        Runtime rt = Runtime.getRuntime();
        Process proc = rt.exec(commandArray, alternativeEnvVars, workingDir);
        Transponder errorForwarder = new Transponder(proc.getErrorStream(), (Transmitter)new Pipe(outputReceiver));
        Transponder outputForwarder = new Transponder(proc.getInputStream(), (Transmitter)new Pipe(outputReceiver));
        errorForwarder.start();
        outputForwarder.start();
        try {
            int retval = proc.waitFor();
            errorForwarder.stop();
            outputForwarder.stop();
            return retval;
        }
        catch (InterruptedException ie) {
            return -1;
        }
    }

    public static int execute(String command, File dir) throws IOException {
        return CommandShell.execute(command, null, dir);
    }

    public static int execute(String command, String[] envVars, File dir) throws IOException {
        return CommandShell.execute(CommandShell.getCommandArrayForCurrentOS(command), envVars, dir, new Forwarder(System.out));
    }

    private static String[] getCommandArrayForCurrentOS(String command) {
        String osName = System.getProperty("os.name");
        String[] cmd = "Windows 95".equals(osName) ? new String[]{"command.com", "/C", command} : (osName.startsWith("Windows") ? new String[]{"cmd.exe", "/C", command} : new String[]{"sh", "-c", command});
        return cmd;
    }

    public static void executeRecursive(String command, String rootdir) throws IOException {
        ArrayList<File> dirs = FileSupport.getDirectoriesInDirectoryTree(rootdir);
        File root = new File(rootdir);
        System.out.println("EXECUTING " + command + " in dir " + root);
        if (!root.exists() || !root.isDirectory()) {
            throw new IllegalArgumentException("root dir '" + rootdir + "' not valid");
        }
        CommandShell.execute(command, new File(rootdir));
        for (File file : dirs) {
            System.out.println("EXECUTING " + command + " in dir " + file);
            CommandShell.execute(command, file);
        }
    }

    public static void main(String[] args) {
        StdIODialog dialog = new StdIODialog(System.in, System.out, new CommandShell(new String[]{"cmd.exe"}, new File("./")));
        try {
            dialog.open();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static class NewLineFilter
    implements Filter<byte[]> {
        @Override
        public byte[] filter(byte[] input) {
            StringBuffer temp = new StringBuffer(new String(input));
            StringSupport.replaceAll(temp, "\r\n", "\n");
            StringSupport.replaceAll(temp, "\r", "\n");
            StringSupport.replaceAll(temp, "\n", "\r\n");
            return temp.toString().getBytes();
        }
    }
}

