/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.execution;

import org.ijsberg.iglu.util.execution.TimeOutException;

public abstract class Executable
implements Runnable {
    private boolean finished;
    private boolean aborted;
    private Throwable execException;
    private Thread executeThread;
    private Object retval;

    @Override
    public void run() {
        try {
            Object result = this.execute();
            if (!this.aborted) {
                this.retval = result;
                this.finished = true;
            }
        }
        catch (InterruptedException ie) {
        }
        catch (Throwable t) {
            this.execException = t;
            this.finished = true;
        }
    }

    public void executeAsync() {
        if (this.executeThread != null) {
            throw new IllegalStateException("use executable once per call");
        }
        this.executeThread = new Thread(this);
        this.executeThread.start();
    }

    public void executeAsyncTimed(final long timeout) {
        if (this.executeThread != null) {
            throw new IllegalStateException("use executable once per call");
        }
        final Executable nestedExec = this;
        Executable exec = new Executable(){

            @Override
            protected Object execute() throws Throwable {
                return nestedExec.executeTimed(timeout);
            }
        };
        exec.executeAsync();
    }

    public void executeAsyncDelayed(final long delay) {
        final Executable nestedExec = this;
        Executable exec = new Executable(){

            @Override
            protected Object execute() throws Throwable {
                return nestedExec.executeDelayed(delay);
            }
        };
        exec.executeAsync();
    }

    public Object executeTimed(long timeout) throws TimeOutException, InterruptedException, Throwable {
        this.executeAsync();
        this.executeThread.join(timeout);
        if (this.execException == null && !this.finished) {
            this.interrupt();
            if (!this.finished) {
                this.execException = new TimeOutException("execution timed out (" + timeout + "ms)");
            }
        }
        if (this.execException != null) {
            throw this.execException;
        }
        return this.retval;
    }

    public Object executeDelayed(long delay) throws TimeOutException, Throwable {
        Thread.sleep(delay);
        return this.executeTimed(0L);
    }

    protected abstract Object execute() throws Throwable;

    public void interrupt() {
        if (!this.aborted) {
            this.aborted = true;
            if (this.executeThread != null) {
                this.executeThread.interrupt();
            }
        }
    }

    public Throwable getExecutionException() {
        return this.execException;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public Thread getExecutionThread() {
        return this.executeThread;
    }

    public Object getReturnValue() {
        return this.retval;
    }
}

