/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.formatting;

import java.math.BigDecimal;
import org.ijsberg.iglu.util.misc.StringSupport;

public class NumberFormatter {
    private char decimalSymbol = (char)44;
    private char digitGroupingSymbol = (char)46;

    public NumberFormatter() {
    }

    public NumberFormatter(char decimalSymbol, char digitGroupingSymbol) {
        this.decimalSymbol = decimalSymbol;
        this.digitGroupingSymbol = digitGroupingSymbol;
    }

    public String format(float number, int nrofDecimals) {
        return this.format(new BigDecimal(number), nrofDecimals);
    }

    public String format(double number, int nrofDecimals) {
        return this.format(new BigDecimal(number), nrofDecimals);
    }

    public String format(BigDecimal number, int nrofDecimals) {
        BigDecimal pow = new BigDecimal(Math.pow(10.0, nrofDecimals));
        String numStr = number.multiply(pow).divide(pow, nrofDecimals, 4).toString();
        int decimalSymbolPos = numStr.indexOf(46);
        numStr = numStr.substring(0, decimalSymbolPos + nrofDecimals + 1);
        if (decimalSymbolPos > -1) {
            numStr = numStr.substring(0, decimalSymbolPos + nrofDecimals + 1);
            numStr = StringSupport.replaceFirst(numStr, ".", String.valueOf(this.decimalSymbol));
        } else {
            decimalSymbolPos = numStr.length();
            numStr = numStr + this.decimalSymbol;
        }
        int nrofMissingZeros = decimalSymbolPos + nrofDecimals - numStr.length();
        for (int i = 0; i <= nrofMissingZeros; ++i) {
            numStr = numStr + '0';
        }
        numStr = StringSupport.replaceFirst(numStr, ".", String.valueOf(this.decimalSymbol));
        if (decimalSymbolPos > 3) {
            StringBuffer numStrBuf = new StringBuffer(numStr);
            int trailingDigits = decimalSymbolPos - (numStr.startsWith("-") ? 1 : 0);
            for (int i = 3; i < trailingDigits; i += 3) {
                numStrBuf.insert(decimalSymbolPos - i, this.digitGroupingSymbol);
            }
            numStr = numStrBuf.toString();
        }
        return numStr;
    }
}

