/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.formatting;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ijsberg.iglu.util.misc.StringSupport;

public abstract class PatternMatchingSupport {
    public static boolean valueMatchesRegularExpression(String val, String regexp) {
        Pattern p = Pattern.compile(regexp);
        return PatternMatchingSupport.valueMatchesRegularExpression(val, p);
    }

    public static boolean valueMatchesRegularExpression(String val, Pattern regexp) {
        Matcher m = regexp.matcher(val);
        return m.matches();
    }

    public static List<int[]> getRangesMatchingRegularExpression(String val, String regexp) {
        ArrayList<int[]> retval = new ArrayList<int[]>();
        Pattern p = Pattern.compile(regexp);
        Matcher matcher = p.matcher(val);
        while (matcher.find()) {
            retval.add(new int[]{matcher.start(), matcher.end()});
        }
        if (matcher.matches()) {
            retval.add(new int[]{matcher.start(), matcher.end()});
        }
        return retval;
    }

    public static boolean valueMatchesWildcardExpression(String val, String exp) {
        String expCopy = StringSupport.replaceAll(exp, new String[]{"[", "\\", "^", "$", ".", "?", "*", "+", "(", ")"}, new String[]{"\\[", "\\\\", "\\^", "\\$", "\\.", ".?", ".*", "\\+", "\\(", "\\)"});
        return PatternMatchingSupport.valueMatchesRegularExpression(val, expCopy);
    }
}

