/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.io;

import java.util.ArrayList;
import org.ijsberg.iglu.util.io.Channel;
import org.ijsberg.iglu.util.io.Receiver;
import org.ijsberg.iglu.util.io.ReceiverQueue;
import org.ijsberg.iglu.util.io.Transmitter;

public class BasicChannel
implements Channel,
Transmitter {
    private ArrayList<Receiver> receivers = new ArrayList();
    private int maxNrofReceivers;
    private boolean echo;
    private String name;
    private boolean closed;

    public BasicChannel(String name) {
        this.name = name;
    }

    public BasicChannel(String name, int maxNrofReceivers) {
        this.name = name;
        this.maxNrofReceivers = maxNrofReceivers;
    }

    public BasicChannel(String name, boolean echo) {
        this.name = name;
        this.echo = echo;
    }

    public BasicChannel(String name, int maxNrofReceivers, boolean echo) {
        this.name = name;
        this.maxNrofReceivers = maxNrofReceivers;
        this.echo = echo;
    }

    @Override
    public void transmit(Object o) {
        this.transmit(o, null);
    }

    public synchronized void transmit(Object o, ReceiverQueue t) {
        if (!this.closed) {
            ArrayList<Receiver> toBeRemoved = new ArrayList<Receiver>();
            for (Receiver r : this.receivers) {
                if (r instanceof ReceiverQueue && ((ReceiverQueue)r).isClosed()) {
                    toBeRemoved.add(r);
                    continue;
                }
                if (!this.echo && r == t) continue;
                r.onReceive(o);
            }
            for (Receiver r : toBeRemoved) {
                this.receivers.remove(r);
            }
        }
    }

    public int getNrofReceivers() {
        return this.receivers.size();
    }

    public ReceiverQueue createReceiver() {
        return this.createReceiver(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReceiverQueue createReceiver(int limit) {
        ArrayList<Receiver> arrayList = this.receivers;
        synchronized (arrayList) {
            ReceiverQueue q = null;
            if (!(this.closed || this.maxNrofReceivers != 0 && this.receivers.size() >= this.maxNrofReceivers)) {
                q = new ReceiverQueue(limit);
                this.receivers.add(q);
            }
            return q;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Receiver registerReceiver(Receiver receiver) {
        ArrayList<Receiver> arrayList = this.receivers;
        synchronized (arrayList) {
            if (this.closed || this.maxNrofReceivers != 0 && this.receivers.size() >= this.maxNrofReceivers) {
                return null;
            }
            this.receivers.add(receiver);
            return receiver;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ArrayList<Receiver> arrayList = this.receivers;
        synchronized (arrayList) {
            for (ReceiverQueue receiverQueue : this.receivers) {
                receiverQueue.onTransmissionClose();
            }
            this.closed = true;
            this.receivers.clear();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer result = new StringBuffer("Pipe: " + this.name + "\n");
        ArrayList<Receiver> arrayList = this.receivers;
        synchronized (arrayList) {
            for (ReceiverQueue receiverQueue : this.receivers) {
                result.append("- r: " + receiverQueue.getNrofQueuedMessages() + " queued\n");
            }
            return result.toString();
        }
    }
}

