/*
 * Decompiled with CFR 0.152.
 */
package org.ijsberg.iglu.util.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.ijsberg.iglu.util.formatting.PatternMatchingSupport;
import org.ijsberg.iglu.util.io.FileSupport;

public class FileFilterRuleSet
implements Cloneable {
    private String includeFilesWithNameMask;
    private String excludeFilesWithNameMask = "";
    private String includeFilesContainingLineMask = "*";
    private String excludeFilesContainingLineMask = "";

    public FileFilterRuleSet(String includeFilesWithNameMask) {
        this.includeFilesWithNameMask = includeFilesWithNameMask;
    }

    public FileFilterRuleSet(String includeFilesWithNameMask, String excludeFilesWithNameMask) {
        this.includeFilesWithNameMask = includeFilesWithNameMask;
        this.excludeFilesWithNameMask = excludeFilesWithNameMask;
    }

    public FileFilterRuleSet(String includeFilesWithNameMask, String excludeFilesWithNameMask, String includeFilesContainingLineMask, String excludeFilesContainingLineMask) {
        this.includeFilesWithNameMask = includeFilesWithNameMask;
        this.excludeFilesWithNameMask = excludeFilesWithNameMask;
        this.includeFilesContainingLineMask = includeFilesContainingLineMask;
        this.excludeFilesContainingLineMask = excludeFilesContainingLineMask;
    }

    public boolean fileMatchesRules(File file) {
        if (file.exists()) {
            String fileName = FileSupport.convertToUnixStylePath(file.getPath());
            try {
                return this.includeBecauseOfName(fileName) && !this.excludeBecauseOfName(fileName) && this.includeBecauseOfContainedTextLine(file) && !this.excludeBecauseOfContainedTextLine(file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean includeBecauseOfName(String fileName) {
        boolean retval = this.includeFilesWithNameMask == null || "*".equals(this.includeFilesWithNameMask) || PatternMatchingSupport.valueMatchesWildcardExpression(fileName, this.includeFilesWithNameMask);
        return retval;
    }

    private boolean excludeBecauseOfName(String fileName) {
        boolean retval = this.excludeFilesWithNameMask != null && !"".equals(this.excludeFilesWithNameMask) && PatternMatchingSupport.valueMatchesWildcardExpression(fileName, this.excludeFilesWithNameMask);
        return retval;
    }

    private boolean includeBecauseOfContainedTextLine(File file) throws IOException {
        boolean retval = this.includeFilesContainingLineMask == null || "*".equals(this.includeFilesContainingLineMask) || FileFilterRuleSet.occurenceFound(file, this.includeFilesContainingLineMask);
        return retval;
    }

    private boolean excludeBecauseOfContainedTextLine(File file) throws IOException {
        boolean retval = this.excludeFilesContainingLineMask != null && !"".equals(this.excludeFilesContainingLineMask) && FileFilterRuleSet.occurenceFound(file, this.excludeFilesContainingLineMask);
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean occurenceFound(File file, String expression) throws IOException {
        FileInputStream input = new FileInputStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!PatternMatchingSupport.valueMatchesWildcardExpression(line, expression)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            reader.close();
            ((InputStream)input).close();
        }
        return false;
    }

    public void setIncludeFilesWithNameMask(String includeFilesWithNameMask) {
        this.includeFilesWithNameMask = includeFilesWithNameMask;
    }

    public void setExcludeFilesWithNameMask(String excludeFilesWithNameMask) {
        this.excludeFilesWithNameMask = excludeFilesWithNameMask;
    }

    public void setIncludeFilesContainingLineMask(String includeFilesContainingLineMask) {
        this.includeFilesContainingLineMask = includeFilesContainingLineMask;
    }

    public void setExcludeFilesContainingLineMask(String excludeFilesContainingLineMask) {
        this.excludeFilesContainingLineMask = excludeFilesContainingLineMask;
    }

    public FileFilterRuleSet clone() {
        return new FileFilterRuleSet(this.includeFilesWithNameMask, this.excludeFilesWithNameMask, this.includeFilesContainingLineMask, this.excludeFilesContainingLineMask);
    }
}

